/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.nbt;

import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import org.apache.commons.lang3.Validate;

public class NBTCache {
    private static final IntegerNumbersCache[] NUM_CACHE = new IntegerNumbersCache[256];
    private static final FloatingNumbersCache ZERO;
    private static final FloatingNumbersCache ONE;
    private static final int LOW = -128;
    private static final int HIGH = 127;

    public static NBTTagByte toCachedByte(NBTTagByte original) {
        int i = original.func_150287_d();
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].byteValue : original;
    }

    public static NBTTagByte getByte(byte b) {
        byte i = b;
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].byteValue : new NBTTagByte(b);
    }

    public static NBTTagInt toCachedInt(NBTTagInt original) {
        int i = original.func_150287_d();
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].intValue : original;
    }

    public static NBTTagInt getInt(int i) {
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].intValue : new NBTTagInt(i);
    }

    public static NBTTagShort toCachedShort(NBTTagShort original) {
        short i = original.func_150289_e();
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].shortValue : original;
    }

    public static NBTTagShort getShort(short i) {
        return i >= -128 && i <= 127 ? NBTCache.NUM_CACHE[i - -128].shortValue : new NBTTagShort(i);
    }

    public static NBTTagLong toCachedLong(NBTTagLong original) {
        long i = original.func_150291_c();
        return i >= -128L && i <= 127L ? NBTCache.NUM_CACHE[(int)(i - -128L)].longValue : original;
    }

    public static NBTTagLong getLong(long i) {
        return i >= -128L && i <= 127L ? NBTCache.NUM_CACHE[(int)(i - -128L)].longValue : new NBTTagLong(i);
    }

    public static NBTTagFloat toCachedFloat(NBTTagFloat original) {
        float i = original.func_150288_h();
        if (i == 0.0f) {
            return NBTCache.ZERO.floatValue;
        }
        if (i == 1.0f) {
            return NBTCache.ONE.floatValue;
        }
        return original;
    }

    public static NBTTagFloat getFloat(float i) {
        if (i == 0.0f) {
            return NBTCache.ZERO.floatValue;
        }
        if (i == 1.0f) {
            return NBTCache.ONE.floatValue;
        }
        return new NBTTagFloat(i);
    }

    public static NBTTagDouble toCachedDouble(NBTTagDouble original) {
        double i = original.func_150286_g();
        if (i == 0.0) {
            return NBTCache.ZERO.doubleValue;
        }
        if (i == 1.0) {
            return NBTCache.ONE.doubleValue;
        }
        return original;
    }

    public static NBTTagDouble getDouble(double i) {
        if (i == 0.0) {
            return NBTCache.ZERO.doubleValue;
        }
        if (i == 1.0) {
            return NBTCache.ONE.doubleValue;
        }
        return new NBTTagDouble(i);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            NBTCache.NUM_CACHE[i] = new IntegerNumbersCache(i + -128);
        }
        ZERO = new FloatingNumbersCache(0.0f);
        ONE = new FloatingNumbersCache(0.0f);
    }

    private static class FloatingNumbersCache {
        final NBTTagFloat floatValue;
        final NBTTagDouble doubleValue;

        private FloatingNumbersCache(float val) {
            this.floatValue = new NBTTagFloat(val);
            this.doubleValue = new NBTTagDouble((double)val);
        }
    }

    private static class IntegerNumbersCache {
        final NBTTagByte byteValue;
        final NBTTagShort shortValue;
        final NBTTagInt intValue;
        final NBTTagLong longValue;

        private IntegerNumbersCache(int n) {
            Validate.isTrue((n >= -128 && n <= 127 ? 1 : 0) != 0);
            this.byteValue = new NBTTagByte((byte)n);
            this.shortValue = new NBTTagShort((short)n);
            this.intValue = new NBTTagInt(n);
            this.longValue = new NBTTagLong((long)n);
        }
    }
}

