/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.MathHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class FireworksHelper {
    private FireworksHelper() {
    }

    public static ItemStack getFireworksStack(int flightDuration, Explosion ... explosions) {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound fireworksTag = new NBTTagCompound();
        NBTTagList explosionsList = new NBTTagList();
        if (explosions != null) {
            for (Explosion e : explosions) {
                if (e == null) continue;
                explosionsList.func_74742_a((NBTBase)e.getTagCompound());
            }
        }
        fireworksTag.func_74774_a("Flight", (byte)MathHelper.clamp(flightDuration, 0, 3));
        fireworksTag.func_74782_a("Explosions", (NBTBase)explosionsList);
        tags.func_74782_a("Fireworks", (NBTBase)fireworksTag);
        ItemStack stack = new ItemStack(Items.field_151152_bP);
        stack.func_77982_d(tags);
        return stack;
    }

    public static ItemStack getRandomFireworks(int flightDuration, int explosions, int primaryColors, int fadeColors) {
        explosions = MathHelper.clamp(explosions, 0, Integer.MAX_VALUE);
        Explosion[] explosionsArray = new Explosion[explosions];
        for (int i = 0; i < explosions; ++i) {
            explosionsArray[i] = Explosion.getRandom(primaryColors, fadeColors);
        }
        return FireworksHelper.getFireworksStack(flightDuration, explosionsArray);
    }

    public static final class Explosion {
        private boolean twinkle = false;
        private boolean trail = false;
        private List<Integer> primaryColors = new ArrayList<Integer>();
        private List<Integer> fadeColors = new ArrayList<Integer>();
        private Type type = Type.BALL;

        public static Explosion getRandom(int primaryColors, int fadeColors) {
            Color color;
            int i;
            primaryColors = MathHelper.clamp(primaryColors, 1, Integer.MAX_VALUE);
            fadeColors = MathHelper.clamp(fadeColors, 1, Integer.MAX_VALUE);
            Explosion e = new Explosion();
            int v = MathHelper.RANDOM.nextInt(4);
            switch (v) {
                case 0: 
                case 2: {
                    e.setTwinkle(true);
                    if (v == 0) break;
                }
                case 1: {
                    e.setTrail(true);
                }
            }
            e.setType(MathHelper.RANDOM.nextInt(5));
            for (i = 0; i < primaryColors; ++i) {
                color = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                e.addPrimaryColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            for (i = 0; i < fadeColors; ++i) {
                color = new Color(Color.HSBtoRGB(MathHelper.RANDOM.nextFloat() * 360.0f, MathHelper.RANDOM.nextFloat() * 0.15f + 0.8f, 0.85f));
                e.addFadeColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            return e;
        }

        public Explosion setTwinkle(boolean twinkle) {
            this.twinkle = twinkle;
            return this;
        }

        public Explosion setTrail(boolean trail) {
            this.trail = trail;
            return this;
        }

        public Explosion setType(Type type) {
            this.type = type;
            return this;
        }

        public Explosion setType(int type) {
            this.setType(Type.values()[MathHelper.clamp(type, 0, Type.values().length - 1)]);
            return this;
        }

        public Explosion addPrimaryColor(int red, int green, int blue) {
            this.primaryColors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public Explosion addFadeColor(int red, int green, int blue) {
            this.fadeColors.add((red << 16) + (green << 8) + blue);
            return this;
        }

        public NBTTagCompound getTagCompound() {
            int i;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("Flicker", this.twinkle);
            tag.func_74757_a("Trail", this.trail);
            tag.func_74774_a("Type", (byte)this.type.ordinal());
            int[] colorArray = new int[this.primaryColors.size()];
            for (i = 0; i < this.primaryColors.size(); ++i) {
                colorArray[i] = this.primaryColors.get(i);
            }
            tag.func_74783_a("Colors", colorArray);
            colorArray = new int[this.fadeColors.size()];
            for (i = 0; i < this.fadeColors.size(); ++i) {
                colorArray[i] = this.fadeColors.get(i);
            }
            tag.func_74783_a("FadeColors", colorArray);
            return tag;
        }

        public ItemStack getFireworkStarStack() {
            NBTTagCompound tags = new NBTTagCompound();
            NBTTagCompound explosionTag = this.getTagCompound();
            tags.func_74782_a("Explosion", (NBTBase)explosionTag);
            ItemStack stack = new ItemStack(Items.field_151154_bQ);
            stack.func_77982_d(tags);
            return stack;
        }

        public static enum Type {
            BALL,
            LARGE_BALL,
            STAR,
            CREEPER,
            BURST;

        }
    }
}

