/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.helpers.ItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ItemWrapper {
    public Item item;
    public int metadata;

    public static ItemWrapper fromItemStack(ItemStack stack) {
        return new ItemWrapper(stack);
    }

    public ItemWrapper(Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public ItemWrapper(ItemStack stack) {
        this(stack.func_77973_b(), ItemHelper.getItemDamage(stack));
    }

    public ItemWrapper(ItemWrapper wrapper) {
        this(wrapper.item, wrapper.metadata);
    }

    public ItemWrapper set(ItemStack stack) {
        if (stack != null) {
            this.item = stack.func_77973_b();
            this.metadata = ItemHelper.getItemDamage(stack);
        } else {
            this.item = null;
            this.metadata = 0;
        }
        return this;
    }

    public boolean isEqual(ItemWrapper other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.item == other.item) {
                return true;
            }
            if (this.item != null && other.item != null) {
                return this.item.delegate.get() == other.item.delegate.get();
            }
        }
        return false;
    }

    public int getId() {
        return Item.func_150891_b((Item)this.item);
    }

    public ItemWrapper clone() {
        return new ItemWrapper(this);
    }

    public boolean equals(Object o) {
        return o instanceof ItemWrapper && this.isEqual((ItemWrapper)o);
    }

    public int hashCode() {
        return this.metadata & 0xFFFF | this.getId() << 16;
    }

    public String toString() {
        return this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "m:" + this.metadata + ", i:" + (this.item == null ? null : this.item.getClass().getName()) + '@' + System.identityHashCode(this.item) + ", v:" + this.getId() + '}';
    }
}

