/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDeconstructor;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.PlanetsProxy;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.venus.ConfigManagerVenus;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="galacticraftplanets", name="Galacticraft Planets", version="4.0.2.244", useMetadata=true, acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:galacticraftcore;", guiFactory="micdoodle8.mods.galacticraft.planets.ConfigGuiFactoryPlanets")
public class GalacticraftPlanets {
    public static final String NAME = "Galacticraft Planets";
    private File GCPlanetsSource;
    @Mod.Instance(value="galacticraftplanets")
    public static GalacticraftPlanets instance;
    public static List<IPlanetsModule> commonModules;
    public static List<IPlanetsModuleClient> clientModules;
    public static final String ASSET_PREFIX = "galacticraftplanets";
    public static final String TEXTURE_PREFIX = "galacticraftplanets:";
    @SidedProxy(clientSide="micdoodle8.mods.galacticraft.planets.PlanetsProxyClient", serverSide="micdoodle8.mods.galacticraft.planets.PlanetsProxy")
    public static PlanetsProxy proxy;
    public static Map<String, List<String>> propOrder;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.GCPlanetsSource = event.getSourceFile();
        this.initModInfo(event.getModMetadata());
        MinecraftForge.EVENT_BUS.register((Object)this);
        File oldMarsConf = new File(event.getModConfigurationDirectory(), "Galacticraft/mars.conf");
        File newPlanetsConf = new File(event.getModConfigurationDirectory(), "Galacticraft/planets.conf");
        boolean update = false;
        if (oldMarsConf.exists()) {
            oldMarsConf.renameTo(newPlanetsConf);
            update = true;
        }
        this.configSyncStart();
        new ConfigManagerMars(newPlanetsConf, update);
        new ConfigManagerAsteroids(new File(event.getModConfigurationDirectory(), "Galacticraft/asteroids.conf"));
        new ConfigManagerVenus(new File(event.getModConfigurationDirectory(), "Galacticraft/venus.conf"));
        this.configSyncEnd(true);
        commonModules.add(new MarsModule());
        commonModules.add(new AsteroidsModule());
        commonModules.add(new VenusModule());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        TileEntityDeconstructor.initialiseRecipeListPlanets();
        if (event.getSide() == Side.SERVER) {
            this.loadLanguagePlanets("en_US");
        }
    }

    public void loadLanguagePlanets(String lang) {
        GCCoreUtil.loadLanguage((String)lang, (String)ASSET_PREFIX, (File)this.GCPlanetsSource);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        proxy.serverInit(event);
    }

    public static void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        for (IPlanetsModuleClient module : clientModules) {
            module.spawnParticle(particleID, position, motion, extraData);
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        IPlanetsModule module = commonModules.get(commonModules.size() - 1);
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("entities")).getChildElements());
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("achievements")).getChildElements());
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("general")).getChildElements());
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("dimensions")).getChildElements());
        list.addAll(new ConfigElement(module.getConfiguration().getCategory("schematic")).getChildElements());
        return list;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals(ASSET_PREFIX)) {
            this.configSyncStart();
            for (IPlanetsModule module : commonModules) {
                module.syncConfig();
            }
            this.configSyncEnd(false);
        }
    }

    private void configSyncEnd(boolean load) {
        ConfigManagerCore.cleanConfig((Configuration)ConfigManagerMars.config, propOrder);
        if (ConfigManagerMars.config.hasChanged()) {
            ConfigManagerMars.config.save();
        }
    }

    private void configSyncStart() {
        propOrder.clear();
    }

    public static void finishProp(Property prop, String currentCat) {
        if (propOrder.get(currentCat) == null) {
            propOrder.put(currentCat, new ArrayList());
        }
        propOrder.get(currentCat).add(prop.getName());
    }

    private void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = ASSET_PREFIX;
        info.name = NAME;
        info.version = "4.0.2.244";
        info.description = "Planets addon for Galacticraft.";
        info.url = "https://micdoodle8.com/";
        info.authorList = Arrays.asList("micdoodle8", "radfast", "EzerArch", "fishtaco", "SpaceViking", "SteveKunG");
        info.logoFile = "assets/galacticraftplanets/galacticraft_logo.png";
    }

    static {
        commonModules = new ArrayList<IPlanetsModule>();
        clientModules = new ArrayList<IPlanetsModuleClient>();
        propOrder = new TreeMap<String, List<String>>();
    }
}

