/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Saturn;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Saturn.worldgen.BiomeProviderSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.ChunkProviderSaturn;
import com.mjr.mjrlegendslib.util.MCUtilities;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldProviderSaturn
extends WorldProviderRealisticSpace {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.98039216f * f), (double)(0.7529412f * f), (double)(0.4509804f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.9411765f * f), (double)(0.627451f * f), (double)(0.21568628f * f));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 10320L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderSaturn.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)ExtraPlanets_Planets.SATURN);
        return BiomeProviderSaturn.class;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.058f;
        }
        return 0.015f;
    }

    public int getHeight() {
        return 800;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.2;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= ExtraPlanets_Planets.SATURN.getTierRequirement();
    }

    public float getFallDamageModifier() {
        if (Config.OLD_STYLE_GRAVITY) {
            return 0.38f;
        }
        return 2.1f;
    }

    public CelestialBody getCelestialBody() {
        return ExtraPlanets_Planets.SATURN;
    }

    public float getThermalLevelModifier() {
        if (Config.THERMAL_PADDINGS) {
            if (MCUtilities.isServer() && this.isDaytime()) {
                return 80.0f;
            }
            return 70.0f;
        }
        return 5.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 3.5;
    }

    @Override
    public int getPressureLevel() {
        return 100;
    }

    @Override
    public int getSolarRadiationLevel() {
        return Config.SATURN_RADIATION_AMOUNT;
    }

    public DimensionType func_186058_p() {
        return ExtraPlanetsDimensions.SATURN;
    }

    public int getDungeonSpacing() {
        return 800;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ExtraPlanets_Blocks.SATURN_BLOCKS);
        return list;
    }
}

