/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockPedestal;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketMobCharmDamage;
import xreliquary.pedestal.PedestalRegistry;
import xreliquary.reference.Settings;
import xreliquary.util.MobHelper;

public class ItemMobCharm
extends ItemBase {
    public static final int ZOMBIE_META = 0;
    public static final int SKELETON_META = 1;
    public static final int WITHER_SKELETON_META = 2;
    public static final int CREEPER_META = 3;
    public static final int WITCH_META = 4;
    public static final int ZOMBIE_PIGMAN_META = 5;
    public static final int CAVE_SPIDER_META = 6;
    public static final int SPIDER_META = 7;
    public static final int ENDERMAN_META = 8;
    public static final int GHAST_META = 9;
    public static final int SLIME_META = 10;
    public static final int MAGMA_CUBE_META = 11;
    public static final int BLAZE_META = 12;
    public static final int GUARDIAN_META = 13;
    private static final String TYPE_TAG = "type";
    public static final Map<Integer, MobCharmDefinition> CHARM_DEFINITIONS = new ImmutableMap.Builder().put((Object)0, (Object)new MobCharmDefinition(0, e -> e instanceof EntityZombie && !(e instanceof EntityPigZombie), "zombie")).put((Object)1, (Object)new MobCharmDefinition(1, e -> e instanceof EntitySkeleton || e instanceof EntityStray, "skeleton")).put((Object)2, (Object)new MobCharmDefinition(2, e -> e instanceof EntityWitherSkeleton, "wither_skeleton")).put((Object)3, (Object)new MobCharmDefinition(3, e -> e instanceof EntityCreeper, "creeper")).put((Object)4, (Object)new MobCharmDefinition(4, e -> e instanceof EntityWitch, "witch")).put((Object)5, (Object)new MobCharmDefinition(5, e -> e instanceof EntityPigZombie, "zombie_pigman")).put((Object)6, (Object)new MobCharmDefinition(6, e -> e instanceof EntityCaveSpider, "cave_spider")).put((Object)7, (Object)new MobCharmDefinition(7, e -> e instanceof EntitySpider && !(e instanceof EntityCaveSpider), "spider")).put((Object)8, (Object)new MobCharmDefinition(8, e -> e instanceof EntityEnderman, "enderman")).put((Object)9, (Object)new MobCharmDefinition(9, e -> e instanceof EntityGhast, "ghast")).put((Object)10, (Object)new MobCharmDefinition(10, e -> e instanceof EntitySlime && !(e instanceof EntityMagmaCube), "slime")).put((Object)11, (Object)new MobCharmDefinition(11, e -> e instanceof EntityMagmaCube, "magma_cube")).put((Object)12, (Object)new MobCharmDefinition(12, e -> e instanceof EntityBlaze, "blaze")).put((Object)13, (Object)new MobCharmDefinition(13, e -> e instanceof EntityGuardian, "guardian")).build();

    public ItemMobCharm() {
        super("mob_charm");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(Settings.Items.MobCharm.durability);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.canRepair = false;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE ? false : super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Nonnull
    public String func_77667_c(ItemStack ist) {
        return "item.mob_charm_" + this.getType(ist);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (byte i = 0; i < CHARM_DEFINITIONS.size(); i = (byte)(i + 1)) {
            ItemStack subItem = new ItemStack((Item)this);
            this.setType(subItem, i);
            subItems.add((Object)subItem);
        }
    }

    public byte getType(ItemStack stack) {
        if (stack.func_77973_b() != this || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b(TYPE_TAG)) {
            return -1;
        }
        return stack.func_77978_p().func_74771_c(TYPE_TAG);
    }

    private void setType(ItemStack stack, byte type) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.func_74774_a(TYPE_TAG, type);
        stack.func_77982_d(compound);
    }

    public static ItemStack getCharmStack(byte meta) {
        ItemStack mobCharm = new ItemStack((Item)ModItems.mobCharm);
        ModItems.mobCharm.setType(mobCharm, meta);
        return mobCharm;
    }

    private int getMobCharmTypeForEntity(Entity entity) {
        for (MobCharmDefinition def : CHARM_DEFINITIONS.values()) {
            if (!def.appliesTo(entity)) continue;
            return def.getMeta();
        }
        return -1;
    }

    @SubscribeEvent
    public void onEntityTargetedEvent(LivingSetAttackTargetEvent event) {
        EntityLiving entity;
        if (event.getTarget() == null) {
            return;
        }
        if (!(event.getTarget() instanceof EntityPlayer) || event.getTarget() instanceof FakePlayer) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getTarget();
        if (this.isMobCharmPresent(player, this.getMobCharmTypeForEntity((Entity)(entity = (EntityLiving)event.getEntity())))) {
            MobHelper.resetTarget(entity);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntity();
        if (this.isPlayer(entity.func_70638_az())) {
            player = (EntityPlayer)entity.func_70638_az();
        } else if (this.isPlayer(entity.func_70643_av())) {
            player = (EntityPlayer)entity.func_70643_av();
        } else {
            return;
        }
        if (this.isMobCharmPresent(player, this.getMobCharmTypeForEntity((Entity)entity))) {
            MobHelper.resetTarget(entity, true, true);
        }
    }

    private boolean isPlayer(EntityLivingBase target) {
        return target instanceof EntityPlayer && !(target instanceof FakePlayer);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource() == null || event.getSource().func_76346_g() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        if (!this.damagePlayersMobCharm(player, event.getEntity())) {
            this.damageMobCharmInPedestal(player, event.getEntity());
        }
    }

    private void damageMobCharmInPedestal(EntityPlayer player, Entity entity) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_71093_bK, player.func_180425_c(), Settings.Items.MobCharm.pedestalRange);
        int mobCharmType = this.getMobCharmTypeForEntity(entity);
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityPedestal)) continue;
            IBlockState blockState = world.func_180495_p(pos);
            TileEntityPedestal pedestal = (TileEntityPedestal)te;
            if (!((Boolean)blockState.func_177229_b((IProperty)BlockPedestal.ENABLED)).booleanValue()) continue;
            for (int slot = 0; slot < pedestal.func_70302_i_(); ++slot) {
                int damage;
                ItemStack slotStack = pedestal.func_70301_a(slot);
                if (slotStack.func_77973_b() == this && this.getType(slotStack) == mobCharmType) {
                    if (slotStack.func_77952_i() + Settings.Items.MobCharm.damagePerKill > slotStack.func_77958_k()) {
                        ((TileEntityPedestal)te).func_70299_a(slot, ItemStack.field_190927_a);
                    } else {
                        slotStack.func_77964_b(slotStack.func_77952_i() + Settings.Items.MobCharm.damagePerKill);
                    }
                    return;
                }
                if (slotStack.func_77973_b() != ModItems.mobCharmBelt || (damage = ModItems.mobCharmBelt.damageCharmType(slotStack, mobCharmType)) <= -1) continue;
                return;
            }
        }
    }

    private boolean damagePlayersMobCharm(EntityPlayer player, Entity entity) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int mobCharmType = this.getMobCharmTypeForEntity(entity);
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(slot);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == this && this.getType(stack) == mobCharmType) {
                if (stack.func_77952_i() + Settings.Items.MobCharm.damagePerKill > stack.func_77958_k()) {
                    player.field_71071_by.field_70462_a.set(slot, (Object)ItemStack.field_190927_a);
                    PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, stack.func_77958_k() + 1, slot), (EntityPlayerMP)player);
                } else {
                    stack.func_77964_b(stack.func_77952_i() + Settings.Items.MobCharm.damagePerKill);
                    PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, stack.func_77952_i(), slot), (EntityPlayerMP)player);
                }
                return true;
            }
            if (!this.damageMobCharmInBelt((EntityPlayerMP)player, mobCharmType, stack)) continue;
            return true;
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack.func_190926_b() || !this.damageMobCharmInBelt((EntityPlayerMP)player, mobCharmType, baubleStack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean damageMobCharmInBelt(EntityPlayerMP player, int mobCharmType, ItemStack slotStack) {
        int damage;
        if (slotStack.func_77973_b() == ModItems.mobCharmBelt && (damage = ModItems.mobCharmBelt.damageCharmType(slotStack, mobCharmType)) > -1) {
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketMobCharmDamage(mobCharmType, damage, -mobCharmType), player);
            return true;
        }
        return false;
    }

    private boolean isMobCharmPresent(EntityPlayer player, int type) {
        return this.playerHasMobCharm(player, type) || this.pedestalWithCharmInRange(player, type);
    }

    private boolean playerHasMobCharm(EntityPlayer player, int type) {
        if (type < 0) {
            return false;
        }
        for (ItemStack slotStack : player.field_71071_by.field_70462_a) {
            if (slotStack.func_190926_b()) continue;
            if (slotStack.func_77973_b() == this && this.getType(slotStack) == type) {
                return true;
            }
            if (slotStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(slotStack, type)) continue;
            return true;
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IBaublesItemHandler inventoryBaubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < inventoryBaubles.getSlots(); ++i) {
                ItemStack baubleStack = inventoryBaubles.getStackInSlot(i);
                if (baubleStack.func_190926_b() || baubleStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(baubleStack, type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pedestalWithCharmInRange(EntityPlayer player, int type) {
        List<BlockPos> pedestalPositions = PedestalRegistry.getPositionsInRange(player.field_71093_bK, player.func_180425_c(), Settings.Items.MobCharm.pedestalRange);
        World world = player.func_130014_f_();
        for (BlockPos pos : pedestalPositions) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityPedestal)) continue;
            IBlockState blockState = world.func_180495_p(pos);
            TileEntityPedestal pedestal = (TileEntityPedestal)te;
            if (!((Boolean)blockState.func_177229_b((IProperty)BlockPedestal.ENABLED)).booleanValue()) continue;
            for (int slot = 0; slot < pedestal.func_70302_i_(); ++slot) {
                ItemStack slotStack = pedestal.func_70301_a(slot);
                if (slotStack.func_77973_b() == this && this.getType(slotStack) == type) {
                    return true;
                }
                if (slotStack.func_77973_b() != ModItems.mobCharmBelt || !ModItems.mobCharmBelt.hasCharmType(slotStack, type)) continue;
                return true;
            }
        }
        return false;
    }

    public static class MobCharmDefinition {
        private int meta;
        private final Function<Entity, Boolean> appliesToEntity;
        private String eggEntityName;

        public MobCharmDefinition(int meta, Function<Entity, Boolean> appliesToEntity, String eggEntityName) {
            this.meta = meta;
            this.appliesToEntity = appliesToEntity;
            this.eggEntityName = eggEntityName;
        }

        public int getMeta() {
            return this.meta;
        }

        public String getEggEntityName() {
            return this.eggEntityName;
        }

        public boolean appliesTo(Entity e) {
            return this.appliesToEntity.apply(e);
        }
    }
}

