/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xreliquary.Reliquary;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.fluid.FluidHandlerInfernalChalice;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class ItemInfernalChalice
extends ItemToggleable {
    public ItemInfernalChalice() {
        super("infernal_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(EntityPlayer player, LivingAttackEvent event) {
                return (event.getSource() == DamageSource.field_76371_c || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76372_a) && player.func_71024_bL().func_75116_a() > 0 && InventoryHelper.playerHasItem(player, ModItems.infernalChalice);
            }

            @Override
            public boolean apply(EntityPlayer player, LivingAttackEvent event) {
                player.func_71020_j(event.getAmount() * ((float)Settings.Items.InfernalChalice.hungerCostPercent / 100.0f));
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
    }

    @Override
    protected void addMoreInformation(ItemStack chalice, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(chalice) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"amount", (Object)String.valueOf(NBTHelper.getInteger("fluidStacks", chalice))), tooltip);
        if (this.isEnabled(chalice)) {
            LanguageHelper.formatTooltip("tooltip.place", tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.drain", tooltip);
        }
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(stack);
        RayTraceResult result = this.func_77621_a(world, player, isInDrainMode);
        if (result == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.func_175660_a(player, result.func_178782_a())) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (!player.func_175151_a(result.func_178782_a(), result.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            IFluidHandler fluidHandler = this.getFluidHandler(stack);
            if (fluidHandler == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBlockState blockState = world.func_180495_p(result.func_178782_a());
            if (this.isEnabled(stack) && (blockState.func_177230_c() == Blocks.field_150356_k || blockState.func_177230_c() == Blocks.field_150353_l) && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && fluidHandler.fill(new FluidStack(FluidRegistry.LAVA, 1000), false) == 1000) {
                world.func_175656_a(result.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                fluidHandler.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!this.isEnabled(stack)) {
                FluidStack fluidDrained = fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), false);
                if (player.field_71075_bZ.field_75098_d || fluidDrained != null && fluidDrained.amount == 1000) {
                    BlockPos adjustedPos = result.func_178782_a().func_177972_a(result.field_178784_b);
                    if (!player.func_175151_a(adjustedPos, result.field_178784_b, stack)) {
                        return new ActionResult(EnumActionResult.PASS, (Object)stack);
                    }
                    if (this.tryPlaceContainedLiquid(world, adjustedPos) && !player.field_71075_bZ.field_75098_d) {
                        fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), true);
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private IFluidHandler getFluidHandler(ItemStack stack) {
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return null;
        }
        return (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    private boolean tryPlaceContainedLiquid(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_185904_a();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150356_k.func_176223_P(), 3);
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerInfernalChalice(stack);
    }
}

