/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.gui.hud;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import xreliquary.client.gui.components.Box;
import xreliquary.client.gui.components.Component;
import xreliquary.client.gui.components.ItemStackPane;
import xreliquary.init.ModItems;
import xreliquary.items.ItemMobCharm;
import xreliquary.reference.Settings;

public class CharmPane
extends Component {
    private static Box mainPane = Box.createVertical(new Component[0]);
    private static final HashMap<Integer, CharmToDraw> charmsToDraw = new HashMap();

    @Override
    public int getHeightInternal() {
        return mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return mainPane.getWidth();
    }

    @Override
    public int getPadding() {
        return 0;
    }

    @Override
    public boolean shouldRender() {
        CharmPane.removeExpiredMobCharms();
        return CharmPane.getCharmsToDraw().size() > 0;
    }

    private static void updateCharmsPane() {
        HashMap<Integer, CharmToDraw> charms = CharmPane.getCharmsToDraw();
        Component[] components = new Component[charms.size()];
        int i = 0;
        for (CharmToDraw charmToDraw : charms.values()) {
            ItemStack stackToRender = ItemMobCharm.getCharmStack(charmToDraw.type);
            stackToRender.func_77964_b(charmToDraw.damage);
            components[i] = new ItemStackPane(stackToRender, false, true);
            ++i;
        }
        mainPane = Box.createVertical(components);
    }

    @Override
    public void renderInternal(int x, int y) {
        mainPane.render(x, y);
    }

    private static synchronized HashMap<Integer, CharmToDraw> getCharmsToDraw() {
        return charmsToDraw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCharmToDraw(byte type, int damage, int slot) {
        int maxMobCharmsToDisplay = Settings.Items.MobCharm.maxCharmsToDisplay;
        HashMap<Integer, CharmToDraw> hashMap = charmsToDraw;
        synchronized (hashMap) {
            if (charmsToDraw.size() == maxMobCharmsToDisplay) {
                charmsToDraw.remove(0);
            }
            if (charmsToDraw.keySet().contains(slot)) {
                charmsToDraw.remove(slot);
            }
            if (damage > ModItems.mobCharm.getMaxDamage(ItemStack.field_190927_a)) {
                charmsToDraw.remove(slot);
            }
            if (damage <= ModItems.mobCharm.getMaxDamage(ItemStack.field_190927_a)) {
                charmsToDraw.put(slot, new CharmToDraw(type, damage, System.currentTimeMillis()));
            }
        }
        CharmPane.updateCharmsPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeExpiredMobCharms() {
        int secondsToExpire = 4;
        HashMap<Integer, CharmToDraw> hashMap = charmsToDraw;
        synchronized (hashMap) {
            Iterator<Map.Entry<Integer, CharmToDraw>> iterator = charmsToDraw.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, CharmToDraw> entry = iterator.next();
                if (Settings.Items.MobCharm.keepAlmostDestroyedDisplayed && (double)entry.getValue().damage >= (double)ModItems.mobCharm.getMaxDamage(ItemStack.field_190927_a) * 0.9 || entry.getValue().time + (long)(secondsToExpire * 1000) >= System.currentTimeMillis()) continue;
                iterator.remove();
                CharmPane.updateCharmsPane();
            }
        }
    }

    private static class CharmToDraw {
        byte type;
        int damage;
        long time;

        CharmToDraw(byte type, int damage, long time) {
            this.type = type;
            this.damage = damage;
            this.time = time;
        }
    }
}

