/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.cheese;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.milk.shared.definition.ICheeseFluidStackFactory;
import growthcraft.milk.shared.definition.ICheeseType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class CheeseRegistry {
    private Map<ResourceLocation, Integer> cheeseNameToId = new HashMap<ResourceLocation, Integer>();
    private List<ICheeseType> cheeseFromId = new ArrayList<ICheeseType>();
    private Map<Fluid, Integer> fluidToCheese = new HashMap<Fluid, Integer>();

    public <ET extends Enum<?>> void registerCheeses(@Nonnull Class<ET> enumClazz) {
        Enum[] values;
        for (Enum type : values = (Enum[])enumClazz.getEnumConstants()) {
            this.registerCheese((ICheeseType)((Object)type));
        }
    }

    public void registerCheese(@Nonnull ICheeseType type) {
        this.registerCheese(type.getRegistryName(), type);
    }

    public void registerCheese(@Nonnull ResourceLocation name, @Nonnull ICheeseType type) {
        Fluid cheeseFluid;
        if (this.cheeseNameToId.containsKey(name)) {
            GrowthcraftLogger.getLogger("growthcraft_milk").warn("There is already a cheese with name " + name + " existing.");
            return;
        }
        this.cheeseFromId.add(type);
        int cheeseId = this.cheeseFromId.size();
        this.cheeseNameToId.put(name, cheeseId);
        ICheeseFluidStackFactory fluidFactory = type.getFluids();
        if (fluidFactory != null && (cheeseFluid = fluidFactory.getFluid()) != null) {
            this.fluidToCheese.put(cheeseFluid, cheeseId);
        }
    }

    public int getCheeseIdFromName(@Nonnull ResourceLocation name) {
        Integer id = this.cheeseNameToId.get(name);
        return id != null ? id : 0;
    }

    public int getCheeseId(@Nonnull ICheeseType type) {
        return this.getCheeseIdFromName(type.getRegistryName());
    }

    public ICheeseType getCheeseByName(@Nonnull ResourceLocation name) {
        int id = this.getCheeseIdFromName(name);
        return id != 0 ? this.getCheeseById(id) : null;
    }

    public ICheeseType getSafeCheeseByName(@Nonnull ResourceLocation name) {
        ICheeseType type = this.getCheeseByName(name);
        return type != null ? type : this.cheeseFromId.get(0);
    }

    public ICheeseType getCheeseByFluid(@Nonnull Fluid fluid) {
        Integer id = this.fluidToCheese.get(fluid);
        if (id == null) {
            return null;
        }
        return this.getCheeseById(id);
    }

    public ICheeseType getSafeCheeseByFluid(@Nonnull Fluid fluid) {
        ICheeseType type = this.getCheeseByFluid(fluid);
        return type != null ? type : this.cheeseFromId.get(0);
    }

    public ICheeseType getCheeseById(int id) {
        if (id <= 0 || id > this.cheeseFromId.size()) {
            return null;
        }
        return this.cheeseFromId.get(id - 1);
    }

    public ICheeseType getSafeCheeseById(int id) {
        ICheeseType type = this.getCheeseById(id);
        return type != null ? type : this.cheeseFromId.get(0);
    }
}

