/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.milk.common.block.BlockOrientable;
import growthcraft.milk.common.tileentity.TileEntityCheesePress;
import growthcraft.milk.shared.init.GrowthcraftMilkBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCheesePress
extends BlockOrientable {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyEnum<AnimationStage> STAGE_PRESS = PropertyEnum.func_177709_a((String)"animstage", AnimationStage.class);
    public static final PropertyBool SUBMODEL_CAP = PropertyBool.func_177716_a((String)"iscap");

    public BlockCheesePress(String unlocalizedName) {
        super(Material.field_151575_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_milk", unlocalizedName));
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 1);
        this.setTileEntityType(TileEntityCheesePress.class);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockCheesePress.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCheesePress cheesePress;
        ItemStack held = playerIn.func_184586_b(hand);
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        if (held.func_190926_b() && !playerIn.func_70093_af() && (cheesePress = (TileEntityCheesePress)this.getTileEntity((IBlockAccess)worldIn, pos)) != null) {
            if (cheesePress.toggle()) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
            }
            return true;
        }
        return false;
    }

    private void updatePressState(World world, BlockPos pos) {
        boolean isPowered = world.func_175640_z(pos);
        TileEntityCheesePress cheesePress = (TileEntityCheesePress)this.getTileEntity((IBlockAccess)world, pos);
        if (cheesePress != null && cheesePress.toggle(isPowered)) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.field_72995_K) {
            this.updatePressState(worldIn, pos);
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityCheesePress te = (TileEntityCheesePress)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return Container.func_94526_b((IInventory)te);
        }
        return 0;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ORIENT, SUBMODEL_CAP});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityCheesePress cheesePress = (TileEntityCheesePress)this.getTileEntity(worldIn, pos);
        state = state.func_177226_a((IProperty)SUBMODEL_CAP, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a(GrowthcraftMilkBlocks.cheesePress.getBlock()));
    }

    public static enum AnimationStage implements IStringSerializable
    {
        UNPRESSED,
        PRESSING,
        PRESSED;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

