/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.block.GrowthcraftRotatableBlockContainer;
import growthcraft.core.shared.block.IRotatableBlock;
import growthcraft.milk.common.block.BlockButterChurn;
import growthcraft.milk.common.tileentity.TileEntityButterChurn;
import growthcraft.milk.common.tileentity.TileEntityButterChurnPlunger;
import growthcraft.milk.shared.init.GrowthcraftMilkBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockButterChurnPlunger
extends GrowthcraftRotatableBlockContainer {
    private static final AxisAlignedBB BOUNDING_BOX_UP = new AxisAlignedBB(0.4375, -0.125, 0.4375, 0.5625, 0.6875, 0.5625);
    private static final AxisAlignedBB BOUNDING_BOX_DOWN = new AxisAlignedBB(0.4375, -0.125, 0.4375, 0.5625, 0.4375, 0.5625);
    public static final PropertyBool SUBMODEL_PLUNGER = PropertyBool.func_177716_a((String)"isplunger");

    public BlockButterChurnPlunger(String unlocalizedName) {
        super(Material.field_151575_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_milk", unlocalizedName));
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE_ROTATION, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)SUBMODEL_PLUNGER, (Comparable)Boolean.valueOf(false)));
        this.setTileEntityType(TileEntityButterChurnPlunger.class);
    }

    private TileEntityButterChurn getMasterTileEntity(IBlockAccess world, BlockPos pos) {
        BlockPos posBelow = pos.func_177977_b();
        IBlockState state = world.func_180495_p(posBelow);
        if (state.func_177230_c() != GrowthcraftMilkBlocks.churn.getBlock()) {
            return null;
        }
        TileEntityButterChurn te = (TileEntityButterChurn)((BlockButterChurn)GrowthcraftMilkBlocks.churn.getBlock()).getTileEntity(world, pos.func_177977_b());
        return te;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityButterChurn te = this.getMasterTileEntity(source, pos);
        if (te != null) {
            if (te.getShaftState() == 0) {
                return BOUNDING_BOX_DOWN;
            }
            return BOUNDING_BOX_UP;
        }
        return BOUNDING_BOX_UP;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockButterChurnPlunger.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX_UP);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (below instanceof IRotatableBlock) {
            return ((IRotatableBlock)below).isRotatable(world, pos.func_177977_b(), side);
        }
        return false;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        if (this.isRotatable((IBlockAccess)world, pos, side)) {
            Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            return below.rotateBlock(world, pos.func_177977_b(), side);
        }
        return false;
    }

    @Override
    public boolean wrenchBlock(World world, BlockPos pos, EntityPlayer player, ItemStack wrench) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (below instanceof BlockButterChurn) {
            return ((BlockButterChurn)below).wrenchBlock(world, pos.func_177977_b(), player, wrench);
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        BlockPos posBelow = pos.func_177977_b();
        Block below = worldIn.func_180495_p(posBelow).func_177230_c();
        if (below instanceof BlockButterChurn) {
            BlockButterChurn churn = (BlockButterChurn)below;
            if (!playerIn.func_70093_af() && churn.tryChurning(worldIn, posBelow, playerIn)) {
                return true;
            }
            return churn.tryWrenchItem(playerIn, worldIn, pos.func_177977_b());
        }
        return false;
    }

    private void updateOrient(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)TYPE_ROTATION);
        world.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing), 3);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.updateOrient(world, pos, state);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updateOrient(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return GrowthcraftMilkBlocks.churn.getBlock() == world.func_180495_p(pos.func_177977_b()).func_177230_c();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.isNormalCube(state, world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ROTATION, SUBMODEL_PLUNGER});
    }
}

