/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftHopsConfig
extends Configuration {
    public static Configuration configuration;
    public static int lagerColor;
    public static int hopAleColor;
    public static int hopVineMaxYield;
    public static float hopVineGrowthRate;
    public static float hopVineFlowerSpawnRate;
    public static int changeVineDropHopSeeds;
    private static final String CATEGORY_GENERAL = "general";

    public static void preInit(FMLPreInitializationEvent e) {
        File directory = e.getModConfigurationDirectory();
        configuration = new Configuration(new File(directory.getPath(), "growthcraft/growthcraft-hops.cfg"));
        GrowthcraftHopsConfig.readConfig();
    }

    public static void readConfig() {
        try {
            configuration.load();
            GrowthcraftHopsConfig.initGeneralConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").log(Level.ERROR, "Unable to load configuration files for Growthcraft Hops!", (Throwable)e);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    private static void initGeneralConfig() {
        changeVineDropHopSeeds = configuration.getInt("chanceVineDropHopSeeds", CATEGORY_GENERAL, changeVineDropHopSeeds, 0, 100, "Chance (percentage) that BlockVine will drop a hop seeds.");
        hopVineMaxYield = configuration.getInt("maxHopYield", CATEGORY_GENERAL, hopVineMaxYield, 0, 10, "Set the maximum number of Hops yielded from hop vines.");
        hopVineGrowthRate = configuration.getFloat("hopGrowthRate", CATEGORY_GENERAL, hopVineGrowthRate, 1.0f, 100.0f, "Chance that a hop vine will grow up the rope.");
        hopVineFlowerSpawnRate = configuration.getFloat("hopFlowerRate", CATEGORY_GENERAL, hopVineFlowerSpawnRate, 1.0f, 100.0f, "Chance that a hop vine will advance in growth age.");
    }

    private static void initDebugConfig() {
    }

    static {
        lagerColor = 10451025;
        hopAleColor = 13676366;
        hopVineMaxYield = 2;
        hopVineGrowthRate = 25.0f;
        hopVineFlowerSpawnRate = 40.0f;
        changeVineDropHopSeeds = 10;
    }
}

