/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class GrowthcraftTreeWorldGen
extends WorldGenAbstractTree {
    private int minTreeHeight = 5;
    private int maxTreeHeight = 6;
    private Block blockLog;
    private Block blockLeaves;
    private Random random = new Random();

    public GrowthcraftTreeWorldGen(Block blockLog, Block blockLeaves, int minTreeHeight, int maxTreeHeight, boolean notify) {
        super(notify);
        this.blockLog = blockLog;
        this.blockLeaves = blockLeaves;
        this.minTreeHeight = minTreeHeight;
        this.maxTreeHeight = maxTreeHeight;
    }

    public GrowthcraftTreeWorldGen(Block blockLog, Block blockLeaves, boolean notify) {
        super(notify);
        this.blockLog = blockLog;
        this.blockLeaves = blockLeaves;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            int maxGrowthHeight = rand.nextInt(this.maxTreeHeight - this.minTreeHeight) + this.minTreeHeight;
            BlockPos baseBlockPos = pos.func_177977_b();
            if (this.canGrow(worldIn, pos, maxGrowthHeight)) {
                for (int i = 1; i <= maxGrowthHeight; ++i) {
                    worldIn.func_175656_a(baseBlockPos.func_177981_b(i), this.blockLog.func_176223_P());
                }
                for (int layerId = maxGrowthHeight + 1; layerId >= maxGrowthHeight - 4; --layerId) {
                    if (layerId == maxGrowthHeight + 1) {
                        this.spawnLeavesOnRadius(worldIn, pos.func_177981_b(layerId), 1, false);
                        continue;
                    }
                    if (layerId == maxGrowthHeight) {
                        this.spawnLeavesOnRadius(worldIn, pos.func_177981_b(layerId), 2, false);
                        continue;
                    }
                    if (layerId == maxGrowthHeight - 1) {
                        this.spawnLeavesOnRadius(worldIn, pos.func_177981_b(layerId), 3, true);
                        continue;
                    }
                    if (layerId != maxGrowthHeight - 2) continue;
                    this.spawnLeavesOnRadius(worldIn, pos.func_177981_b(layerId), 3, true);
                }
                return true;
            }
        }
        return false;
    }

    private boolean canGrow(World worldIn, BlockPos pos, int growthHeight) {
        for (int i = 1; i <= growthHeight; ++i) {
            Block block = worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c();
            if (block instanceof BlockAir) continue;
            return false;
        }
        return true;
    }

    private void spawnLeaves(World worldIn, BlockPos pos) {
        if (this.isReplaceable(worldIn, pos)) {
            worldIn.func_175656_a(pos, this.blockLeaves.func_176223_P());
        }
    }

    private void spawnLeavesOnRadius(World worldIn, BlockPos centerPos, int radius, boolean randomLeaves) {
        BlockPos posUpperLeft = new BlockPos(centerPos.func_177958_n() + radius, centerPos.func_177956_o(), centerPos.func_177952_p() + radius);
        BlockPos posLowerRight = new BlockPos(centerPos.func_177958_n() - radius, centerPos.func_177956_o(), centerPos.func_177952_p() - radius);
        Iterable blockPosList = BlockPos.func_177980_a((BlockPos)posUpperLeft, (BlockPos)posLowerRight);
        blockPosList.forEach(blockPos -> {
            boolean spawnBlock = true;
            if (worldIn.func_180495_p(blockPos).func_177230_c() instanceof BlockAir && spawnBlock) {
                this.spawnLeaves(worldIn, (BlockPos)blockPos);
            }
        });
    }
}

