/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import java.util.Arrays;

public class StringUtils {
    private StringUtils() {
    }

    public static String capitalize(String str) {
        if (str.length() <= 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String inspect(Object obj) {
        if (obj == null) {
            return "@null";
        }
        if (obj.getClass().isArray()) {
            if (obj.getClass().getComponentType().isArray()) {
                return Arrays.deepToString((Object[])((Object[][])obj));
            }
            return Arrays.toString((Object[])obj);
        }
        return obj.toString();
    }

    public static boolean isIDInList(int id, String list) {
        String[] itemArray = list.split(";");
        for (int i = 0; i < itemArray.length; ++i) {
            String[] values = itemArray[i].split(",");
            int tempID = StringUtils.parseInt(values[0], Integer.MAX_VALUE);
            if (tempID == Integer.MAX_VALUE || tempID != id) continue;
            return true;
        }
        return false;
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

