/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.component;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.heatsource.IHeatSourceBlock;
import growthcraft.core.shared.block.BlockCheck;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatBlockComponent {
    private TileEntity tileEntity;
    private EnumFacing sourceDir = EnumFacing.DOWN;
    private float adjacentHeating;

    public HeatBlockComponent(TileEntity te, float adh) {
        this.tileEntity = te;
        this.adjacentHeating = adh;
    }

    private World getWorld() {
        return this.tileEntity.func_145831_w();
    }

    public float getHeatMultiplierFromDir(EnumFacing dir) {
        BlockPos pos = this.tileEntity.func_174877_v().func_177972_a(dir);
        IBlockState blockState = this.getWorld().func_180495_p(pos);
        IHeatSourceBlock heatSource = CellarRegistry.instance().heatSource().getHeatSource(blockState);
        if (heatSource != null) {
            return heatSource.getHeat(this.getWorld(), pos);
        }
        return 0.0f;
    }

    public float getHeatMultiplierForAdjacent() {
        if (this.adjacentHeating > 0.0f) {
            float heat = 0.0f;
            for (EnumFacing dir : BlockCheck.DIR4) {
                heat += this.getHeatMultiplierFromDir(dir);
            }
            return heat * this.adjacentHeating;
        }
        return 0.0f;
    }

    public float getHeatMultiplier() {
        return this.getHeatMultiplierFromDir(this.sourceDir) + this.getHeatMultiplierForAdjacent();
    }
}

