/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.item;

import growthcraft.core.shared.handlers.FluidHandlerContainerItemWrapper;
import growthcraft.core.shared.item.GrowthcraftItemFoodBase;
import growthcraft.core.shared.item.IFluidContainerItem;
import growthcraft.core.shared.item.IItemColored;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemFoodBottleFluid
extends GrowthcraftItemFoodBase
implements IFluidContainerItem,
IItemColored {
    private Fluid defaultFluid;
    private int color = -1;

    public ItemFoodBottleFluid(@Nullable Fluid defaultFluid, int healAmount, float saturation, boolean isWolfFavouriteFood) {
        super(healAmount, saturation, isWolfFavouriteFood);
        this.setItemUseAction(EnumAction.DRINK);
        this.func_77642_a(Items.field_151069_bo);
        if (defaultFluid == null) {
            defaultFluid = FluidRegistry.WATER;
        }
        this.defaultFluid = defaultFluid;
    }

    public ItemFoodBottleFluid(@Nullable Fluid defaultFluid, int healAmount, float saturation) {
        this(defaultFluid, healAmount, saturation, false);
    }

    public ItemFoodBottleFluid(@Nullable Fluid defaultFluid, int healAmount) {
        this(defaultFluid, healAmount, 0.0f);
    }

    public ItemFoodBottleFluid(@Nullable Fluid defaultFluid) {
        this(defaultFluid, 0);
    }

    @Override
    public FluidStack getFluidStack(ItemStack stack) {
        return new FluidStack(this.defaultFluid, 250);
    }

    public ItemFoodBottleFluid setColor(int c) {
        this.color = c;
        return this;
    }

    @Override
    public int getColor(ItemStack stack) {
        if (this.color != -1) {
            return this.color;
        }
        return this.defaultFluid.getColor();
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerContainerItemWrapper(stack);
    }
}

