/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.config.description.Describer;
import growthcraft.core.shared.effect.AbstractEffect;
import growthcraft.core.shared.effect.IEffect;
import growthcraft.core.shared.io.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EffectWeightedRandomList
extends AbstractEffect {
    private List<WeightedEffect> effects = new ArrayList<WeightedEffect>();

    public EffectWeightedRandomList add(int weight, @Nonnull IEffect effect) {
        this.effects.add(new WeightedEffect(weight, effect));
        return this;
    }

    public WeightedEffect getWeightedEffect(int index) {
        return this.effects.get(index);
    }

    public int getItemWeight(int index) {
        WeightedEffect effect = this.getWeightedEffect(index);
        if (effect != null) {
            return effect.field_76292_a;
        }
        return 0;
    }

    public IEffect getItemEffect(int index) {
        WeightedEffect effect = this.getWeightedEffect(index);
        if (effect != null) {
            return effect.getEffect();
        }
        return null;
    }

    public EffectWeightedRandomList concat(@Nonnull EffectWeightedRandomList other) {
        this.effects.addAll(other.effects);
        return this;
    }

    public EffectWeightedRandomList concat(@Nonnull List<WeightedEffect> other) {
        this.effects.addAll(other);
        return this;
    }

    public EffectWeightedRandomList copy() {
        return new EffectWeightedRandomList().concat(this.effects);
    }

    public WeightedEffect getRandomItem(@Nonnull Random random) {
        return (WeightedEffect)WeightedRandom.func_76271_a((Random)random, this.effects);
    }

    public int size() {
        return this.effects.size();
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        WeightedEffect effect = this.getRandomItem(random);
        if (effect != null) {
            effect.apply(world, entity, random, data);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        int totalWeight = WeightedRandom.func_76272_a(this.effects);
        ArrayList<String> tempList = new ArrayList<String>();
        for (WeightedEffect effect : this.effects) {
            tempList.clear();
            effect.getDescription(tempList);
            if (tempList.size() <= 0) continue;
            float chance = totalWeight > 0 ? (float)effect.field_76292_a / (float)totalWeight : 0.0f;
            String head = I18n.func_74837_a((String)"effect.weighted_random_list.format", (Object[])new Object[]{(int)(chance * 100.0f)});
            Describer.compactDescription(head, list, tempList);
        }
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.effects.clear();
        ArrayList<IEffect> list = new ArrayList<IEffect>();
        NBTHelper.loadEffectsList(list, data);
        for (IEffect effect : list) {
            if (!(effect instanceof WeightedEffect)) continue;
            this.effects.add((WeightedEffect)effect);
        }
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        ArrayList<IEffect> list = new ArrayList<IEffect>();
        for (IEffect iEffect : this.effects) {
            list.add(iEffect);
        }
        NBTHelper.writeEffectsList(data, list);
    }

    public static class WeightedEffect
    extends WeightedRandom.Item
    implements IEffect {
        private IEffect effect;

        public WeightedEffect(int weight, @Nonnull IEffect eff) {
            super(weight);
            this.effect = eff;
        }

        public WeightedEffect() {
            super(1);
        }

        public IEffect getEffect() {
            return this.effect;
        }

        @Override
        public void apply(World world, Entity entity, Random random, Object data) {
            this.effect.apply(world, entity, random, data);
        }

        @Override
        public void getDescription(List<String> list) {
            this.effect.getDescription(list);
        }

        protected void readFromNBT(NBTTagCompound data) {
            this.field_76292_a = data.func_74762_e("item_weight");
            if (data.func_74764_b("effect")) {
                this.effect = CoreRegistry.instance().getEffectsRegistry().loadEffectFromNBT(data, "effect");
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound data, String name) {
            if (data.func_74764_b(name)) {
                NBTTagCompound effectData = data.func_74775_l(name);
                this.readFromNBT(effectData);
            }
        }

        protected void writeToNBT(NBTTagCompound data) {
            data.func_74768_a("item_weight", this.field_76292_a);
            if (this.effect != null) {
                this.effect.writeToNBT(data, "effect");
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound data, String name) {
            NBTTagCompound target = new NBTTagCompound();
            String effectName = CoreRegistry.instance().getEffectsRegistry().getName(this.getClass());
            target.func_74778_a("__name__", effectName);
            this.writeToNBT(target);
            data.func_74782_a(name, (NBTBase)target);
        }
    }
}

