/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config.schema;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.config.schema.ICommentable;
import growthcraft.core.shared.config.schema.IValidatable;
import growthcraft.core.shared.definition.IMultiFluidStacks;
import growthcraft.core.shared.fluids.FluidTag;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.fluids.MultiFluidStacks;
import growthcraft.core.shared.fluids.TaggedFluidStacks;
import growthcraft.core.shared.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MultiFluidStackSchema
implements ICommentable,
IValidatable,
IMultiFluidStacks {
    public String name;
    public List<String> names = new ArrayList<String>();
    public List<String> inclusion_tags = new ArrayList<String>();
    public List<String> exclusion_tags = new ArrayList<String>();
    public String comment = "";
    public int amount;

    public MultiFluidStackSchema(@Nonnull IMultiFluidStacks fluidStacks) {
        if (fluidStacks instanceof TaggedFluidStacks) {
            TaggedFluidStacks taggedStack = (TaggedFluidStacks)fluidStacks;
            this.inclusion_tags.addAll(taggedStack.getTags());
            this.exclusion_tags.addAll(taggedStack.getExclusionTags());
        } else if (fluidStacks instanceof MultiFluidStacks) {
            this.names.addAll(((MultiFluidStacks)fluidStacks).getNames());
        } else {
            throw new IllegalArgumentException("Expected a TaggedFluidStacks or a MultiFluidStacks");
        }
        this.amount = fluidStacks.getAmount();
    }

    public MultiFluidStackSchema(@Nonnull FluidStack fluidStack) {
        this.name = fluidStack.getFluid().getName();
        this.amount = fluidStack.amount;
    }

    public MultiFluidStackSchema() {
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    private List<FluidTag> expandTagNames(@Nonnull List<String> tagNames) {
        return CoreRegistry.instance().fluidTags().expandTagNames(tagNames);
    }

    public List<FluidTag> expandInclusionTags() {
        return this.expandTagNames(this.inclusion_tags);
    }

    public List<FluidTag> expandExclusionTags() {
        return this.expandTagNames(this.exclusion_tags);
    }

    public Collection<Fluid> getFluidsByTags() {
        HashSet<Fluid> result = new HashSet<Fluid>();
        Collection<Fluid> fluids = CoreRegistry.instance().fluidDictionary().getFluidsByTags(this.expandInclusionTags());
        Collection<Fluid> exfluids = CoreRegistry.instance().fluidDictionary().getFluidsByTags(this.expandExclusionTags());
        result.addAll(fluids);
        result.removeAll(exfluids);
        return result;
    }

    public Collection<Fluid> getFluidsByNames() {
        Fluid fluid;
        HashSet<Fluid> result = new HashSet<Fluid>();
        if (this.name != null && (fluid = FluidRegistry.getFluid((String)this.name)) != null) {
            result.add(fluid);
        }
        for (String fluidName : this.names) {
            Fluid fluid2 = FluidRegistry.getFluid((String)fluidName);
            if (fluid2 == null) continue;
            result.add(fluid2);
        }
        return result;
    }

    public Collection<Fluid> getFluids() {
        HashSet<Fluid> result = new HashSet<Fluid>();
        result.addAll(this.getFluidsByTags());
        result.addAll(this.getFluidsByNames());
        return result;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        for (Fluid fluid : this.getFluids()) {
            stacks.add(new FluidStack(fluid, this.amount));
        }
        return stacks;
    }

    public List<IMultiFluidStacks> getMultiFluidStacks() {
        ArrayList<IMultiFluidStacks> result = new ArrayList<IMultiFluidStacks>();
        result.add(new TaggedFluidStacks(this.amount, this.inclusion_tags, this.exclusion_tags));
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (Fluid fluid : this.getFluidsByNames()) {
            fluidStacks.add(new FluidStack(fluid, this.amount));
        }
        result.add(new MultiFluidStacks(fluidStacks));
        return result;
    }

    @Override
    public boolean containsFluid(Fluid expectedFluid) {
        if (FluidTest.isValid(expectedFluid)) {
            for (Fluid fluid : this.getFluids()) {
                if (fluid != expectedFluid) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsFluidStack(FluidStack stack) {
        if (FluidTest.isValid(stack)) {
            Fluid expected = stack.getFluid();
            return this.containsFluid(expected);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return !this.getFluids().isEmpty();
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    public String toString() {
        return String.format("Schema<MultiFluidStack>(comment: '%s', name: '%s', names: %s, inclusion_tags: %s, exclusion_tags: %s, amount: %d)", StringUtils.inspect(this.comment), StringUtils.inspect(this.name), this.names, this.inclusion_tags, this.exclusion_tags, this.amount);
    }

    public static MultiFluidStackSchema newWithTags(int amount, String ... tags) {
        MultiFluidStackSchema schema = new MultiFluidStackSchema();
        for (String tag : tags) {
            schema.inclusion_tags.add(tag);
        }
        schema.amount = amount;
        return schema;
    }

    @Override
    public List<ItemStack> getItemStacks() {
        return GrowthcraftFluidUtils.getFluidContainers(this.getFluidStacks());
    }
}

