/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.client.gui;

import growthcraft.core.shared.client.gui.GrowthcraftGuiContainer;
import growthcraft.core.shared.utils.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public class TooltipManager<C extends Container, T extends TileEntity> {
    public final GrowthcraftGuiContainer<C, T> gui;
    protected final List<TooltipIndex> tooltipIndices = new ArrayList<TooltipIndex>();
    protected final List<String> tooltipCache = new ArrayList<String>();

    public TooltipManager(GrowthcraftGuiContainer<C, T> g) {
        this.gui = g;
    }

    public void addTooltipIndex(String handle, Rectangle r) {
        this.tooltipIndices.add(new TooltipIndex(handle, r));
    }

    public void addTooltipIndex(String handle, int x, int y, int w, int h) {
        this.addTooltipIndex(handle, new Rectangle(x, y, w, h));
    }

    protected void drawTooltipIndex(TooltipIndex ti, int x, int y) {
        this.tooltipCache.clear();
        this.gui.addTooltips(ti.handle, this.tooltipCache);
        if (this.tooltipCache.size() > 0) {
            this.gui.func_146283_a(this.tooltipCache, x, y);
        }
    }

    protected void drawTooltip(int mx, int my) {
        int gx = mx - (this.gui.field_146294_l - this.gui.getXSize()) / 2;
        int gy = my - (this.gui.field_146295_m - this.gui.getYSize()) / 2;
        for (TooltipIndex ti : this.tooltipIndices) {
            if (!ti.rect.contains(gx, gy)) continue;
            this.drawTooltipIndex(ti, mx, my);
            break;
        }
    }

    public void draw(int mx, int my) {
        this.drawTooltip(mx, my);
    }

    public static class TooltipIndex {
        public final String handle;
        public final Rectangle rect;

        public TooltipIndex(String h, Rectangle r) {
            this.handle = h;
            this.rect = r;
        }
    }
}

