/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.block;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.core.shared.block.GrowthcraftBlockBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockPaddyBase
extends GrowthcraftBlockBase {
    public static final PropertyBool MOISTURE = PropertyBool.func_177716_a((String)"moisture");
    public static final PropertyBool IS_RADIOACTIVE = PropertyBool.func_177716_a((String)"is_radioactive");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockPaddyBase(Material material) {
        super(material);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MOISTURE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IS_RADIOACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MOISTURE, IS_RADIOACTIVE, NORTH, EAST, SOUTH, WEST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)MOISTURE, (Comparable)Boolean.valueOf(this.hasFluidSource(worldIn, pos))).func_177226_a((IProperty)IS_RADIOACTIVE, (Comparable)Boolean.valueOf(this.hasRadioactiveSource(worldIn, pos))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectPaddyTo(worldIn, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectPaddyTo(worldIn, pos, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectPaddyTo(worldIn, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectPaddyTo(worldIn, pos, EnumFacing.WEST)));
    }

    public boolean canConnectPaddyTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return BlockCheck.isBlockPaddy(block);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean isConnectedNorth = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean isConnectedEast = (Boolean)state.func_177229_b((IProperty)EAST);
        boolean isConnectedSouth = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean isConnectedWest = (Boolean)state.func_177229_b((IProperty)WEST);
        if (this.hasRadioactiveSource((IBlockAccess)worldIn, pos)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_RADIOACTIVE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(isConnectedNorth)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(isConnectedEast)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(isConnectedSouth)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(isConnectedWest)), 3);
        } else if (this.hasFluidSource((IBlockAccess)worldIn, pos)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_RADIOACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(isConnectedNorth)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(isConnectedEast)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(isConnectedSouth)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(isConnectedWest)), 3);
        } else {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)MOISTURE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)IS_RADIOACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(isConnectedNorth)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(isConnectedEast)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(isConnectedSouth)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(isConnectedWest)), 3);
        }
    }

    public boolean hasFluidSource(IBlockAccess worldIn, BlockPos pos) {
        int maxFieldRange = 4;
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-maxFieldRange, 0, -maxFieldRange), (BlockPos)pos.func_177982_a(maxFieldRange, 1, maxFieldRange))) {
            if (FluidRegistry.lookupFluidForBlock((Block)worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c()) == null || FluidRegistry.lookupFluidForBlock((Block)worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c()).getName() != "water") continue;
            return true;
        }
        return false;
    }

    public boolean hasRadioactiveSource(IBlockAccess worldIn, BlockPos pos) {
        int maxFieldRange = 4;
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-maxFieldRange, 0, -maxFieldRange), (BlockPos)pos.func_177982_a(maxFieldRange, 1, maxFieldRange))) {
            if (FluidRegistry.lookupFluidForBlock((Block)worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c()) == null || FluidRegistry.lookupFluidForBlock((Block)worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c()).getName() != "yellorium") continue;
            return true;
        }
        return false;
    }

    public boolean isRadioactive(World worldIn, BlockPos pos) {
        return this.hasRadioactiveSource((IBlockAccess)worldIn, pos);
    }

    public boolean isMoisture(World worldIn, BlockPos pos) {
        return this.hasFluidSource((IBlockAccess)worldIn, pos);
    }
}

