/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.booze;

import growthcraft.cellar.shared.booze.BoozeEffect;
import growthcraft.cellar.shared.booze.BoozeEntry;
import growthcraft.cellar.shared.booze.modifier.IModifierFunction;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.fluids.FluidTag;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BoozeRegistry {
    private Map<Fluid, BoozeEntry> boozeMap = new HashMap<Fluid, BoozeEntry>();
    private Map<FluidTag, IModifierFunction> tagModifierFunctions = new HashMap<FluidTag, IModifierFunction>();

    public IModifierFunction getModifierFunction(@Nullable FluidTag tag) {
        return this.tagModifierFunctions.get(tag);
    }

    public void setModifierFunction(@Nonnull FluidTag tag, IModifierFunction func) {
        this.tagModifierFunctions.put(tag, func);
    }

    public Collection<BoozeEntry> getBoozeEntries() {
        return this.boozeMap.values();
    }

    private void ensureFluidIsValid(Fluid fluid) {
        if (!GrowthcraftFluidUtils.doesFluidExist(fluid)) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being registered as a Booze is not registered to the FluidRegistry.");
        }
    }

    @Nullable
    public BoozeEntry getBoozeEntry(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return this.boozeMap.get(fluid);
    }

    @Nonnull
    public BoozeEntry fetchBoozeEntry(Fluid fluid) {
        BoozeEntry entry = this.getBoozeEntry(fluid);
        if (entry == null) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being tagged does not have a valid booze entry.");
        }
        return entry;
    }

    @Nullable
    public BoozeEffect getEffect(Fluid fluid) {
        BoozeEntry entry = this.getBoozeEntry(fluid);
        return entry != null ? entry.getEffect() : null;
    }

    public boolean isFluidBooze(Fluid f) {
        if (f == null) {
            return false;
        }
        return this.getBoozeEntry(f) != null;
    }

    public boolean isFluidBooze(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        return this.isFluidBooze(fluidStack.getFluid());
    }

    protected void registerBooze(@Nonnull Fluid fluid, @Nonnull BoozeEntry entry) {
        this.boozeMap.put(fluid, entry);
    }

    public void registerBooze(@Nonnull Fluid fluid) {
        this.ensureFluidIsValid(fluid);
        if (this.isFluidBooze(fluid)) {
            throw new IllegalArgumentException("[Growthcraft|Cellar] The fluid being registered as a Booze is already registered to the CellarRegistry.");
        }
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Registering booze %s", (Object)fluid.getName());
        this.registerBooze(fluid, new BoozeEntry(fluid));
    }
}

