/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.events.EventBrewed;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.cellar.shared.processing.brewing.IBrewingRecipe;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.GrowthcraftCore;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BrewKettle
extends DeviceProgressive<IBrewingRecipe> {
    private float grain;
    private DeviceInventorySlot brewingSlot;
    private DeviceInventorySlot residueSlot;
    private DeviceInventorySlot lidSlot;
    private DeviceFluidSlot inputFluidSlot;
    private DeviceFluidSlot outputFluidSlot;
    private TileHeatingComponent heatComponent;

    public BrewKettle(TileEntityCellarDevice te, int brewSlotId, int residueSlotId, int lidSlotId, int inputFluidSlotId, int outputFluidSlotId) {
        super(te);
        this.brewingSlot = new DeviceInventorySlot((IInventory)te, brewSlotId);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, residueSlotId);
        this.lidSlot = new DeviceInventorySlot((IInventory)te, lidSlotId);
        this.inputFluidSlot = new DeviceFluidSlot(te, inputFluidSlotId);
        this.outputFluidSlot = new DeviceFluidSlot(te, outputFluidSlotId);
        this.heatComponent = new TileHeatingComponent(te, 0.5f);
    }

    public void setGrain(float g) {
        this.grain = g;
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    public BrewKettle setHeatMultiplier(float h) {
        this.heatComponent.setHeatMultiplier(h);
        return this;
    }

    public boolean isHeated() {
        return this.getHeatMultiplier() > 0.0f;
    }

    public boolean hasFluid() {
        return this.inputFluidSlot.hasContent() || this.outputFluidSlot.hasContent();
    }

    @Override
    protected IBrewingRecipe loadRecipe() {
        boolean hasLid = GrowthcraftCellarItems.brewKettleLid.equals(this.lidSlot.get().func_77973_b());
        return CellarRegistry.instance().brewing().findRecipe(GrowthcraftFluidUtils.removeStackTags(this.inputFluidSlot.get()), this.brewingSlot.get(), hasLid);
    }

    @Override
    public boolean canProcess() {
        IBrewingRecipe recipe = (IBrewingRecipe)this.getWorkingRecipe();
        try {
            if (recipe == null) {
                return false;
            }
            if (this.inputFluidSlot.get() == null) {
                return false;
            }
            if (!this.inputFluidSlot.hasEnough(recipe.getInputFluidStack())) {
                return false;
            }
            if (!this.brewingSlot.hasEnough(recipe.getInputItemStack())) {
                return false;
            }
            if (!this.outputFluidSlot.hasCapacityFor(recipe.getFluidStack())) {
                return false;
            }
            return this.residueSlot.hasCapacityFor(recipe.getResidue().residueItem);
        }
        catch (NullPointerException e) {
            GrowthcraftCore.logger.error("There is an error in the growthcraft_cellar brewing recipes. Delete the brewing.json file or update it with the new entries from brewing.json.default");
            return false;
        }
    }

    private void produceGrain(IBrewingRecipe recipe) {
        Residue res = recipe.getResidue();
        if (res != null) {
            this.grain += res.pomaceRate;
            while (this.grain >= 1.0f) {
                this.grain -= 1.0f;
                this.residueSlot.increaseStack(res.residueItem);
            }
        }
    }

    @Override
    protected void process(IBrewingRecipe recipe) {
        this.produceGrain(recipe);
        this.inputFluidSlot.consume(GrowthcraftFluidUtils.replaceFluidStackTags(recipe.getInputFluidStack(), this.inputFluidSlot.get()), true);
        this.outputFluidSlot.fill(recipe.asFluidStack(), true);
        if (!CellarRegistry.instance().brewing().isFallbackRecipe(recipe)) {
            this.brewingSlot.consume(recipe.getInputItemStack());
        } else {
            this.brewingSlot.consume(1);
        }
        this.markForUpdate(true);
        MinecraftForge.EVENT_BUS.post((Event)new EventBrewed(this.parent, recipe));
    }

    @Override
    protected float getSpeedMultiplier() {
        return super.getSpeedMultiplier() * this.getHeatMultiplier();
    }

    @Override
    public void update() {
        this.heatComponent.update();
        super.update();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.grain = data.func_74760_g("grain");
        this.heatComponent.readFromNBT(data, "heat_component");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("grain", this.grain);
        this.heatComponent.writeToNBT(data, "heat_component");
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.grain = buf.readFloat();
        this.heatComponent.readFromStream(buf);
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeFloat(this.grain);
        this.heatComponent.writeToStream(buf);
        return false;
    }
}

