/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.client.particle.emitter.BrewKettleLidSteamEmitter;
import growthcraft.cellar.client.particle.params.FluidTanksParams;
import growthcraft.cellar.client.render.RenderBrewKettle;
import growthcraft.cellar.client.utils.FXHelperCellar;
import growthcraft.cellar.common.inventory.ContainerBrewKettle;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.BrewKettle;
import growthcraft.cellar.common.tileentity.fluids.CellarTank;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.core.shared.client.utils.FXHelper;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.ITileHeatedDevice;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import growthcraft.core.shared.utils.Pair;
import growthcraft.core.shared.utils.SpatialRandom;
import growthcraft.core.shared.utils.Triplet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityBrewKettle
extends TileEntityCellarDevice
implements ITickable,
ITileHeatedDevice,
ITileProgressiveDevice {
    private static final int[] rawSlotIDs = new int[]{0, 1, 2};
    private static final int[] residueSlotIDs = new int[]{0};
    private DeviceInventorySlot invSlotForLid = new DeviceInventorySlot((IInventory)this, 2);
    private BrewKettle brewKettle = new BrewKettle(this, 0, 1, 2, 0, 1);
    private BrewKettleLidSteamEmitter lidSteamEmitter = new BrewKettleLidSteamEmitter();
    private SpatialRandom sprand = new SpatialRandom();
    private boolean animLastLid = false;

    @Override
    public DeviceBase[] getDevices() {
        return new DeviceBase[]{this.brewKettle};
    }

    @Override
    protected FluidTank[] createTanks() {
        int maxCap = GrowthcraftCellarConfig.brewKettleMaxCap;
        return new FluidTank[]{new CellarTank(maxCap, this), new CellarTank(maxCap, this)};
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 3);
    }

    @Override
    protected void markFluidDirty() {
        this.markForUpdate(true);
        super.markFluidDirty();
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.growthcraft.brewKettle";
    }

    @Override
    public String getGuiID() {
        return "growthcraft_cellar:brew_kettle";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBrewKettle(playerInventory, this);
    }

    @Override
    public float getDeviceProgress() {
        return this.brewKettle.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.brewKettle.getProgressScaled(scale);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.brewKettle.update();
        } else if (this.hasFluid() && this.isHeated()) {
            if (this.hasLid()) {
                this.lidSteamEmitter.update(this.field_145850_b, this.field_174879_c);
                this.animLastLid = true;
            } else {
                if (this.animLastLid) {
                    for (int i = 0; i < 10; ++i) {
                        if (this.field_145850_b.field_73012_v.nextInt(10) < 3) continue;
                        Pair<Double, Double> pPos = this.sprand.nextCenteredD2();
                        Pair<Double, Double> pVel = this.sprand.nextCenteredD2();
                        double px = (double)this.field_174879_c.func_177958_n() + 0.5 + (Double)pPos.left * 0.875;
                        double py = (double)this.field_174879_c.func_177956_o() + 0.9375;
                        double pz = (double)this.field_174879_c.func_177952_p() + 0.5 + (Double)pPos.right * 0.875;
                        double vx = (Double)pVel.left * 0.0625;
                        double vy = 0.0625;
                        double vz = (Double)pVel.right * 0.0625;
                        FXHelper.emitSteamBig(this.field_145850_b, px, py, pz, vx, vy, vz);
                    }
                }
                if (this.field_145850_b.field_73012_v.nextInt(10) < 3) {
                    Triplet<Double, Double, Double> pPos = this.sprand.nextCenteredD3();
                    double px = (double)this.field_174879_c.func_177958_n() + 0.5 + (Double)pPos.left * 0.75;
                    double py = (double)this.field_174879_c.func_177956_o() + 0.5;
                    double pz = (double)this.field_174879_c.func_177952_p() + 0.5 + (Double)pPos.right * 0.75;
                    double vx = 0.0;
                    double vy = 0.125;
                    double vz = 0.0;
                    FluidTanksParams params = new FluidTanksParams(RenderBrewKettle.BBOX_FLUID.grow(-0.0625, 0.0, -0.0625).translate(0.0, 0.0, 0.0), this);
                    FXHelperCellar.emitKettleBubbles(this.field_145850_b, px, py, pz, vx, vy, vz, params);
                }
                this.animLastLid = false;
            }
        } else {
            this.animLastLid = false;
        }
    }

    @Override
    public int getHeatScaled(int range) {
        return (int)(MathHelper.func_76131_a((float)this.brewKettle.getHeatMultiplier(), (float)0.0f, (float)1.0f) * (float)range);
    }

    @Override
    public boolean isHeated() {
        return this.brewKettle.isHeated();
    }

    @Override
    public float getHeatMultiplier() {
        return this.brewKettle.getHeatMultiplier();
    }

    public boolean canBrew() {
        return this.brewKettle.canProcess();
    }

    public boolean hasFluid() {
        return this.brewKettle.hasFluid();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? rawSlotIDs : residueSlotIDs;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side != EnumFacing.DOWN || slot == 1;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_BrewKettle(NBTTagCompound nbt) {
        this.brewKettle.readFromNBT(nbt, "brew_kettle");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_BrewKettle(NBTTagCompound nbt) {
        this.brewKettle.writeToNBT(nbt, "brew_kettle");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_BrewKettle(ByteBuf stream) throws IOException {
        this.brewKettle.readFromStream(stream);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_BrewKettle(ByteBuf stream) throws IOException {
        this.brewKettle.writeToStream(stream);
        return false;
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        BrewKettleDataID dataId = BrewKettleDataID.getByOrdinal(id);
        switch (dataId) {
            case TIME: {
                this.brewKettle.setTime(v);
                break;
            }
            case TIME_MAX: {
                this.brewKettle.setTimeMax(v);
                break;
            }
            case HEAT_AMOUNT: {
                this.brewKettle.setHeatMultiplier((float)v / 32767.0f);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, BrewKettleDataID.TIME.ordinal(), (int)this.brewKettle.getTime());
        iCrafting.func_71112_a(container, BrewKettleDataID.TIME_MAX.ordinal(), this.brewKettle.getTimeMax());
        iCrafting.func_71112_a(container, BrewKettleDataID.HEAT_AMOUNT.ordinal(), (int)(this.brewKettle.getHeatMultiplier() * 32767.0f));
    }

    @Override
    protected int doFill(EnumFacing from, FluidStack resource, boolean shouldFill) {
        if (this.hasLid()) {
            return 0;
        }
        return this.fillFluidTank(0, resource, shouldFill);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, int maxDrain, boolean shouldDrain) {
        if (this.hasLid()) {
            return null;
        }
        return this.drainFluidTank(1, maxDrain, shouldDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, FluidStack stack, boolean shouldDrain) {
        if (this.hasLid()) {
            return null;
        }
        if (stack == null || !stack.isFluidEqual(this.getFluidStack(1))) {
            return null;
        }
        return this.doDrain(from, stack.amount, shouldDrain);
    }

    public void switchTanks() {
        FluidStack f0 = null;
        FluidStack f1 = null;
        if (this.getFluidStack(0) != null) {
            f0 = this.getFluidStack(0).copy();
        }
        if (this.getFluidStack(1) != null) {
            f1 = this.getFluidStack(1).copy();
        }
        this.clearTank(0);
        this.clearTank(1);
        this.getFluidTank(0).fill(f1, true);
        this.getFluidTank(1).fill(f0, true);
        this.markForUpdate(true);
    }

    public boolean hasLid() {
        return GrowthcraftCellarItems.brewKettleLid.equals(this.func_70301_a(2).func_77973_b());
    }

    public static enum BrewKettleDataID {
        TIME,
        TIME_MAX,
        HEAT_AMOUNT,
        UNKNOWN;

        public static final BrewKettleDataID[] VALUES;

        public static BrewKettleDataID getByOrdinal(int ord) {
            if (ord >= 0 && ord < VALUES.length) {
                return VALUES[ord];
            }
            return UNKNOWN;
        }

        static {
            VALUES = new BrewKettleDataID[]{TIME, TIME_MAX, HEAT_AMOUNT};
        }
    }
}

