/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.core.shared.block.BlockUtils;
import growthcraft.core.shared.block.IRotatableBlock;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFermentBarrel
extends BlockCellarContainer
implements IRotatableBlock {
    private static final PropertyEnum<BarrelRotation> TYPE_BARREL_ROTATION = PropertyEnum.func_177709_a((String)"brotation", BarrelRotation.class);
    private static final PropertyBool TYPE_TAP = PropertyBool.func_177716_a((String)"hastap");

    public BlockFermentBarrel(String unlocalizedName) {
        super(Material.field_151575_d);
        this.setTileEntityType(TileEntityFermentBarrel.class);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE_TAP, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE_BARREL_ROTATION, (Comparable)((Object)BarrelRotation.HOR_NORTH)));
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_cellar", unlocalizedName));
    }

    @Override
    protected boolean shouldRestoreBlockState(World world, BlockPos pos, ItemStack stack) {
        return true;
    }

    @Override
    protected boolean shouldDropTileStack(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return true;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_TAP, TYPE_BARREL_ROTATION});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_BARREL_ROTATION, (Comparable)((Object)BarrelRotation.values()[meta & 7]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BarrelRotation)((Object)state.func_177229_b(TYPE_BARREL_ROTATION))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityFermentBarrel te = (TileEntityFermentBarrel)this.getTileEntity(worldIn, pos);
        if (te != null && te.hasTap()) {
            return state.func_177226_a((IProperty)TYPE_TAP, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityFermentBarrel te = (TileEntityFermentBarrel)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.getDeviceProgressScaled(15);
        }
        return 0;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void doRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        BarrelRotation rot = (BarrelRotation)((Object)state.func_177229_b(TYPE_BARREL_ROTATION));
        switch (rot) {
            case HOR_NORTH: {
                rot = BarrelRotation.HOR_WEST;
                break;
            }
            case HOR_WEST: {
                rot = BarrelRotation.HOR_SOUTH;
                break;
            }
            case HOR_SOUTH: {
                rot = BarrelRotation.HOR_EAST;
                break;
            }
            case HOR_EAST: {
                rot = BarrelRotation.VER_NORTH;
                break;
            }
            case VER_NORTH: {
                rot = BarrelRotation.VER_WEST;
                break;
            }
            case VER_WEST: {
                rot = BarrelRotation.VER_SOUTH;
                break;
            }
            case VER_SOUTH: {
                rot = BarrelRotation.VER_EAST;
                break;
            }
            case VER_EAST: {
                rot = BarrelRotation.HOR_NORTH;
            }
        }
        world.func_180501_a(pos, state.func_177226_a(TYPE_BARREL_ROTATION, (Comparable)((Object)rot)), 3);
    }

    protected void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            boolean isHorizontal;
            EnumFacing facing = BlockUtils.getDefaultDirection(world, pos, state);
            boolean bl = isHorizontal = facing != EnumFacing.UP && facing != EnumFacing.DOWN;
            if (!isHorizontal) {
                facing = EnumFacing.WEST;
            }
            BarrelRotation rot = BarrelRotation.fromFacing(facing, isHorizontal);
            world.func_180501_a(pos, state.func_177226_a(TYPE_BARREL_ROTATION, (Comparable)((Object)rot)), 3);
        }
    }

    protected BarrelRotation setOrientWhenPlacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer) {
        EnumFacing toDecideHorVer = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        boolean isHorizontal = toDecideHorVer != EnumFacing.UP && toDecideHorVer != EnumFacing.DOWN;
        EnumFacing facing = EnumFacing.func_176733_a((double)placer.field_70177_z);
        BarrelRotation rot = BarrelRotation.fromFacing(facing, isHorizontal);
        worldIn.func_180501_a(pos, state.func_177226_a(TYPE_BARREL_ROTATION, (Comparable)((Object)rot)), 3);
        return rot;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.setOrientWhenPlacing(worldIn, pos, state, placer);
    }

    public static enum BarrelRotation implements IStringSerializable
    {
        HOR_NORTH(1),
        HOR_SOUTH(3),
        HOR_WEST(2),
        HOR_EAST(0),
        VER_NORTH(1),
        VER_SOUTH(3),
        VER_WEST(2),
        VER_EAST(0);

        public final int rotationCW;

        private BarrelRotation(int rotationCW) {
            this.rotationCW = rotationCW;
        }

        public static BarrelRotation fromFacing(EnumFacing facing, boolean isHorizontal) {
            switch (facing) {
                case NORTH: {
                    return isHorizontal ? HOR_NORTH : VER_NORTH;
                }
                case SOUTH: {
                    return isHorizontal ? HOR_SOUTH : VER_SOUTH;
                }
                default: {
                    return isHorizontal ? HOR_WEST : VER_WEST;
                }
                case EAST: {
                    return isHorizontal ? HOR_EAST : VER_EAST;
                }
                case UP: 
                case DOWN: 
            }
            if (isHorizontal) {
                throw new IllegalArgumentException("Must be vertical!");
            }
            return VER_WEST;
        }

        public EnumFacing toFacing() {
            switch (this) {
                case HOR_NORTH: 
                case VER_NORTH: {
                    return EnumFacing.NORTH;
                }
                case HOR_SOUTH: 
                case VER_SOUTH: {
                    return EnumFacing.SOUTH;
                }
                default: {
                    return EnumFacing.WEST;
                }
                case HOR_EAST: 
                case VER_EAST: 
            }
            return EnumFacing.EAST;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

