/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo;

import growthcraft.bamboo.common.CommonProxy;
import growthcraft.bamboo.common.Init;
import growthcraft.bamboo.shared.config.GrowthcraftBambooConfig;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="growthcraft_bamboo", name="Growthcraft Bamboo", version="4.1.3.200", dependencies="required-after:growthcraft", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftBamboo {
    private static final String CLIENT_PROXY_CLASS = "growthcraft.bamboo.client.ClientProxy";
    private static final String SERVER_PROXY_CLASS = "growthcraft.bamboo.common.CommonProxy";
    public static Configuration configuration;
    @Mod.Instance(value="growthcraft_bamboo")
    public static GrowthcraftBamboo instance;
    @SidedProxy(serverSide="growthcraft.bamboo.common.CommonProxy", clientSide="growthcraft.bamboo.client.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        GrowthcraftBambooConfig.preInit(event);
        if (GrowthcraftBambooConfig.enableGrowthcraftBamboo) {
            Init.preInitBlocks();
            Init.preInitItems();
            proxy.preInit();
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        if (GrowthcraftBambooConfig.enableGrowthcraftBamboo) {
            Init.registerRecipes();
            Init.registerSmeltingRecipes();
            proxy.init();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        Init.registerBlockOres();
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (GrowthcraftBambooConfig.enableGrowthcraftBamboo) {
            IForgeRegistry registry = event.getRegistry();
            Init.registerBlocks((IForgeRegistry<Block>)registry);
            proxy.registerStateMappers();
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        if (GrowthcraftBambooConfig.enableGrowthcraftBamboo) {
            IForgeRegistry registry = event.getRegistry();
            Init.registerItems((IForgeRegistry<Item>)registry);
            Init.registerBlockItems((IForgeRegistry<Item>)registry);
            proxy.postRegisterItems();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        if (GrowthcraftBambooConfig.enableGrowthcraftBamboo) {
            Init.registerItemRenders();
            Init.registerBlockRenders();
        }
    }
}

