/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.block;

import growthcraft.apples.shared.init.GrowthcraftApplesBlocks;
import growthcraft.core.shared.block.GrowthcraftBlockLeaves;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockAppleLeaves
extends GrowthcraftBlockLeaves
implements IGrowable {
    public static final int LEAVES_COLOR = 5825053;
    private static final int APPLE_CHECK_AREA = 3;
    private static final int MAX_APPLES_IN_AREA = 2;

    public BlockAppleLeaves(String unlocalizedName) {
        super("growthcraft_apples", unlocalizedName, GrowthcraftApplesBlocks.blockAppleSapling);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.canSustainApple(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockAir) {
            worldIn.func_175656_a(pos.func_177977_b(), GrowthcraftApplesBlocks.blockApple.getDefaultState());
        }
    }

    private boolean canSustainApple(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return false;
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block instanceof BlockAir;
    }

    private boolean canSpawnApple(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canSustainApple(worldIn, pos, state)) {
            return false;
        }
        int iX = pos.func_177958_n();
        int iY = pos.func_177956_o();
        int iZ = pos.func_177952_p();
        BlockPos.MutableBlockPos mutpos = new BlockPos.MutableBlockPos();
        int countApples = 0;
        for (int jX = -3; jX <= 3; ++jX) {
            for (int jY = -3; jY <= 3; ++jY) {
                for (int jZ = -3; jZ <= 3; ++jZ) {
                    mutpos.func_181079_c(iX + jX, iY + jY, iZ + jZ);
                    IBlockState iblockstate = worldIn.func_180495_p((BlockPos)mutpos);
                    if (iblockstate.func_177230_c() != GrowthcraftApplesBlocks.blockApple.getBlock() || ++countApples < 2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && worldIn.func_175671_l(pos.func_177984_a()) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(7) == 0 ? 1 : 0) != 0) && this.canSpawnApple(worldIn, pos, state)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.field_73012_v.nextInt(chance) == 0) {
            BlockAppleLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151034_e));
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return GrowthcraftApplesBlocks.blockAppleSapling.getItem();
    }
}

