/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.lib;

import net.minecraftforge.common.config.Configuration;
import org.icannt.netherendingores.common.registry.BlockRecipeData;
import org.icannt.netherendingores.common.registry.OreDictionaryOtherData;
import org.icannt.netherendingores.lib.Log;
import org.icannt.netherendingores.lib.StringUtil;
import org.icannt.netherendingores.proxy.CommonProxy;

public class Config {
    public static Boolean advancedDebugging = false;
    public static Boolean addCrystalChargedCertusQuartz = true;
    public static Boolean addOreDilithium = false;
    public static Boolean addOreTritanium = false;
    public static Boolean inductionSmelterFullOutput = false;
    public static float inductionSmelterFullOutputAmountFactor = 1.0f;
    public static float inductionSmelterFullOutputEnergyFactor = 2.0f;
    public static float inductionSmelterReducedOutputAmountFactor = 0.6666667f;
    public static float inductionSmelterReducedOutputEnergyFactor = 0.6f;
    public static Boolean pulverizerFullOutput = false;
    public static float pulverizerFullOutputAmountFactor = 1.0f;
    public static float pulverizerFullOutputEnergyFactor = 2.0f;
    public static float pulverizerReducedOutputAmountFactor = 0.6666667f;
    public static float pulverizerReducedOutputEnergyFactor = 0.6f;
    public static Boolean redstoneFurnaceFullOutput = false;
    public static float redstoneFurnaceFullOutputAmountFactor = 1.0f;
    public static float redstoneFurnaceFullOutputEnergyFactor = 2.0f;
    public static float redstoneFurnaceReducedOutputAmountFactor = 0.6666667f;
    public static float redstoneFurnaceReducedOutputEnergyFactor = 0.6f;
    public static Boolean industrialCraft2Recipes = true;
    public static Boolean mekanismRecipes = true;
    public static Boolean thermalExpansionRecipes = true;
    public static Boolean tinkersConstructRecipes = true;
    public static Boolean vanillaCraftingRecipes = true;
    public static Boolean vanillaFurnaceRecipes = true;
    private static final String CATEGORY_GENERAL_SETTINGS = "general settings";
    private static final String CATEGORY_ORE_DICT_SETTINGS = "ore dictionary settings";
    private static final String CATEGORY_MACHINE_RECIPE_SETTINGS = "machine recipe settings";
    private static final String CATEGORY_RECIPE_INTEGRATION_SETTINGS = "recipe integration settings";
    private static final String CATEGORY_RECIPE_MULTIPLIER_OVERRIDE = "recipe multipliers override";
    private static final String CATEGORY_RECIPE_MULTIPLIER = "recipe multipliers";
    private static int override = -1;
    private static int minMult = 0;
    private static int maxMult = 3;

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.initGeneralSettingsConfig(cfg);
            Config.initOreDictSettingsConfig(cfg);
            Config.initRecipeIntegrationSettingsConfig(cfg);
            Config.initMachineRecipeSettingsConfig(cfg);
            Config.initRecipeMultiplierOverrideConfig(cfg);
            Config.initRecipeMultiplierConfig(cfg);
        }
        catch (Exception e1) {
            Log.LOG.error("Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralSettingsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL_SETTINGS, "General Settings");
        advancedDebugging = cfg.getBoolean("Advanced debugging", CATEGORY_GENERAL_SETTINGS, advancedDebugging.booleanValue(), "Enable advanced debugging. Show all trace level messages in debug.log. Only enable if you really need it.");
    }

    private static void initOreDictSettingsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_ORE_DICT_SETTINGS, "Ore Dictionary Settings");
        boolean enabled = false;
        for (OreDictionaryOtherData oD : OreDictionaryOtherData.values()) {
            enabled = cfg.getBoolean(oD.func_176610_l(), CATEGORY_ORE_DICT_SETTINGS, oD.getDefaultSetting(), "Add " + oD.getModItemDescName() + " from " + oD.getModDescName() + " to the Ore Dictionary." + oD.getConfigExtraDesc());
            oD.setEnabled(enabled);
        }
    }

    private static void initMachineRecipeSettingsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_MACHINE_RECIPE_SETTINGS, "Settings for Thermal Expansion machine processing\r\nPlease ask the mod author trab if you need assistance understanding how this works");
        float minFactor = 0.5f;
        float maxFullFactor = 3.0f;
        float maxReducedFactor = 1.0f;
        inductionSmelterFullOutput = cfg.getBoolean("Induction Smelter full output", CATEGORY_MACHINE_RECIPE_SETTINGS, inductionSmelterFullOutput.booleanValue(), "Enable full Induction Smelter output. Do not reduce output for augment compensation, uses much more energy.");
        inductionSmelterFullOutputAmountFactor = cfg.getFloat("Induction Smelter full output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, inductionSmelterFullOutputAmountFactor, 0.5f, 3.0f, "Induction Smelter full output amount factor.");
        inductionSmelterFullOutputEnergyFactor = cfg.getFloat("Induction Smelter full output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, inductionSmelterFullOutputEnergyFactor, 0.5f, 3.0f, "Induction Smelter full output energy factor.");
        inductionSmelterReducedOutputAmountFactor = cfg.getFloat("Induction Smelter reduced output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, inductionSmelterReducedOutputAmountFactor, 0.5f, 1.0f, "Induction Smelter reduced output amount factor.");
        inductionSmelterReducedOutputEnergyFactor = cfg.getFloat("Induction Smelter reduced output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, inductionSmelterReducedOutputEnergyFactor, 0.5f, 1.0f, "Induction Smelter reduced output energy factor.");
        pulverizerFullOutput = cfg.getBoolean("Pulverizer full output", CATEGORY_MACHINE_RECIPE_SETTINGS, pulverizerFullOutput.booleanValue(), "Enable full Pulverizer output. Do not reduce output for augment compensation, uses much more energy.");
        pulverizerFullOutputAmountFactor = cfg.getFloat("Pulverizer full output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, pulverizerFullOutputAmountFactor, 0.5f, 3.0f, "Pulverizer full output amount factor.");
        pulverizerFullOutputEnergyFactor = cfg.getFloat("Pulverizer full output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, pulverizerFullOutputEnergyFactor, 0.5f, 3.0f, "Pulverizer full output energy factor.");
        pulverizerReducedOutputAmountFactor = cfg.getFloat("Pulverizer reduced output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, pulverizerReducedOutputAmountFactor, 0.5f, 1.0f, "Pulverizer reduced output amount factor.");
        pulverizerReducedOutputEnergyFactor = cfg.getFloat("Pulverizer reduced output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, pulverizerReducedOutputEnergyFactor, 0.5f, 1.0f, "Pulverizer reduced output energy factor.");
        redstoneFurnaceFullOutput = cfg.getBoolean("Redstone Furnace full output", CATEGORY_MACHINE_RECIPE_SETTINGS, redstoneFurnaceFullOutput.booleanValue(), "Enable full Redstone Furnace output. Do not reduce output for augment compensation, uses much more energy.");
        redstoneFurnaceFullOutputAmountFactor = cfg.getFloat("Redstone Furnace full output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, redstoneFurnaceFullOutputAmountFactor, 0.5f, 3.0f, "Redstone Furnace full output amount factor.");
        redstoneFurnaceFullOutputEnergyFactor = cfg.getFloat("Redstone Furnace full output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, redstoneFurnaceFullOutputEnergyFactor, 0.5f, 3.0f, "Redstone Furnace full output energy factor.");
        redstoneFurnaceReducedOutputAmountFactor = cfg.getFloat("Redstone Furnace reduced output amount factor", CATEGORY_MACHINE_RECIPE_SETTINGS, redstoneFurnaceReducedOutputAmountFactor, 0.5f, 1.0f, "Redstone Furnace reduced output amount factor.");
        redstoneFurnaceReducedOutputEnergyFactor = cfg.getFloat("Redstone Furnace reduced output energy factor", CATEGORY_MACHINE_RECIPE_SETTINGS, redstoneFurnaceReducedOutputEnergyFactor, 0.5f, 1.0f, "Redstone Furnace reduced output energy factor.");
    }

    private static void initRecipeIntegrationSettingsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_RECIPE_INTEGRATION_SETTINGS, "Enable or disable recipe integrations");
        industrialCraft2Recipes = cfg.getBoolean("Industrial Craft 2 recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, industrialCraft2Recipes.booleanValue(), "Enable Industrial Craft 2 recipe integration");
        mekanismRecipes = cfg.getBoolean("Mekanism recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, mekanismRecipes.booleanValue(), "Enable Mekanism recipe integration");
        thermalExpansionRecipes = cfg.getBoolean("Thermal Expansion recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, thermalExpansionRecipes.booleanValue(), "Enable Thermal Expansion recipe integration");
        tinkersConstructRecipes = cfg.getBoolean("Tinkers' Construct recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, tinkersConstructRecipes.booleanValue(), "Enable Tinkers' Construct recipe integration");
        vanillaCraftingRecipes = cfg.getBoolean("Vanilla crafting recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, vanillaCraftingRecipes.booleanValue(), "Enable crafting recipes to convert to oredict ores, only works with 1x recipe multiplier");
        vanillaFurnaceRecipes = cfg.getBoolean("Vanilla furnace recipes", CATEGORY_RECIPE_INTEGRATION_SETTINGS, vanillaFurnaceRecipes.booleanValue(), "Enable furnace recipes to smelt to oredict ores.");
    }

    private static void initRecipeMultiplierConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_RECIPE_MULTIPLIER, "0 = No recipes/standard oredict, ideal for craftweaker.\r\n    Oredict entries prefixed with \"neo\" for easy craftteaker use.\r\n1 = Oredict mode uses the same oredict name as the target ore, also adds recipe to craft target ore if needed.\r\n2 = Crush to dust at 2x rate with mod specific bonuses | Smelt to 2x oredict ore.\r\n    Oredict entries prefixed with \"oreEnd\", \"oreNether\" or \"oreOverworld\" respectively.\r\n3 = Crush to 4x oredict ore | Smelt to 3x oredict ore.\r\n    Oredict entries prefixed with \"oreDenseEnd\", \"oreDenseNether\" or \"oreDenseOverworld\" respectively.\r\n");
        int multiplier = 0;
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            multiplier = cfg.get(CATEGORY_RECIPE_MULTIPLIER, StringUtil.spaceCapital(blockData.func_176610_l()), blockData.getDefaultRecipeMultiplier()).getInt();
            multiplier = Math.min(maxMult, Math.max(minMult, multiplier));
            if (override > -1) {
                multiplier = Math.min(maxMult, Math.max(minMult, override));
            }
            blockData.setRecipeMultiplier(multiplier);
        }
    }

    private static void initRecipeMultiplierOverrideConfig(Configuration cfg) {
        override = cfg.getInt("Override Multipliers", CATEGORY_RECIPE_MULTIPLIER_OVERRIDE, -1, -1, maxMult, "Change this setting to override all recipe multipliers, -1 means ignore.");
        override = Math.min(maxMult, Math.max(-1, override));
    }
}

