/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.integration.common.registry;

import cofh.api.util.ThermalExpansionHelper;
import net.minecraft.item.ItemStack;
import org.icannt.netherendingores.common.registry.BlockRecipeData;
import org.icannt.netherendingores.common.registry.RecipeHelper;
import org.icannt.netherendingores.lib.Log;

public class TERecipeRegistry {
    public static void removeRecipes() {
        Log.debug("Removing Automatic Thermal Expansion Recipes");
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            ThermalExpansionHelper.removeFurnaceRecipe((ItemStack)blockData.getModBlockItemStack());
            ThermalExpansionHelper.removePulverizerRecipe((ItemStack)blockData.getModBlockItemStack());
        }
        Log.info("Removed Automatic Thermal Expansion Recipes");
    }

    public static void registerRecipes() {
        Log.debug("Registering Thermal Expansion Recipes");
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            RecipeHelper.tryRecipe(blockData, "indsmeltsand", true);
            RecipeHelper.tryRecipe(blockData, "indsmeltsand", false);
        }
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            RecipeHelper.tryRecipe(blockData, "indsmeltrichslag", true);
            RecipeHelper.tryRecipe(blockData, "indsmeltrichslag", false);
        }
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            RecipeHelper.tryRecipe(blockData, "pulv", true);
            RecipeHelper.tryRecipe(blockData, "pulv", false);
        }
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (blockData.getRecipeMultiplier() <= 1) continue;
            RecipeHelper.tryRecipe(blockData, "redfurn", true);
            RecipeHelper.tryRecipe(blockData, "redfurn", false);
        }
        Log.info("Registered Thermal Expansion Recipes");
    }
}

