/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.icannt.netherendingores.common.registry.BlockRecipeData;
import org.icannt.netherendingores.common.registry.RecipeHelper;
import org.icannt.netherendingores.lib.Config;
import org.icannt.netherendingores.lib.Log;

@GameRegistry.ObjectHolder(value="netherendingores")
public class RecipeRegistry {
    public static void registerRecipes() {
        Log.debug("Registering Vanilla Recipes");
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (!Config.vanillaCraftingRecipes.booleanValue() || blockData.getRecipeMultiplier() != 1) continue;
            RecipeHelper.tryRecipe(blockData, "craft", true);
            RecipeHelper.tryRecipe(blockData, "craft", false);
        }
        for (BlockRecipeData blockData : BlockRecipeData.values()) {
            if (!Config.vanillaFurnaceRecipes.booleanValue() || blockData.getRecipeMultiplier() <= 1 && (blockData.getRecipeMultiplier() != 1 || !blockData.isFurnaceItemEnabled())) continue;
            RecipeHelper.tryRecipe(blockData, "furnace", true);
            RecipeHelper.tryRecipe(blockData, "furnace", false);
        }
        Log.info("Registered Vanilla Recipes");
    }

    public static void addCraftingRecipe(BlockRecipeData blockData, String material) {
        ResourceLocation groupName = new ResourceLocation("netherendingores:ore_conversions");
        Log.logRecipeMsg("crafting", blockData.func_176610_l(), blockData.getOreDictOutputName("", material));
        GameRegistry.addShapelessRecipe((ResourceLocation)blockData.getConversionResourceLocation(material), (ResourceLocation)groupName, (ItemStack)blockData.getOtherModBlockItemStack(material), (Ingredient[])blockData.getConversionIngredient());
    }

    public static void addFurnaceRecipe(BlockRecipeData blockData, String material) {
        int experience = blockData.getRecipeMultiplier() > 1 ? 0 : -1;
        Log.logRecipeMsg("furnace", blockData.func_176610_l(), blockData.getOreDictOutputName("smelt", material));
        if (FurnaceRecipes.func_77602_a().func_151395_a(blockData.getModBlockItemStack()) == ItemStack.field_190927_a) {
            FurnaceRecipes.func_77602_a().func_151394_a(blockData.getModBlockItemStack(), blockData.getOreDictSmeltItemStack(blockData.getFurnaceAmount()), (float)experience);
        } else {
            Log.isRecipeAddedAlready = true;
        }
    }
}

