/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import org.icannt.netherendingores.common.registry.BlockRecipeData;
import org.icannt.netherendingores.common.registry.RecipeRegistry;
import org.icannt.netherendingores.integration.common.data.IC2RecipeData;
import org.icannt.netherendingores.integration.common.data.MekRecipeData;
import org.icannt.netherendingores.integration.common.data.TEIndSmeltRecipeData;
import org.icannt.netherendingores.integration.common.data.TERecipeData;
import org.icannt.netherendingores.integration.common.data.TiCRecipeData;
import org.icannt.netherendingores.lib.Log;

public class RecipeHelper {
    public static void tryRecipe(BlockRecipeData blockData, String device, Boolean doAltReplace) {
        String[] materials = new String[]{blockData.func_176610_l()};
        if (doAltReplace.booleanValue()) {
            materials = blockData.getItemAltOreDictSuffix();
        }
        for (String material : materials) {
            if (doAltReplace.booleanValue()) {
                material = blockData.getAltMaterialName(material);
            }
            try {
                RecipeHelper.addRecipe(blockData, device, material);
                if (Log.isRecipeAddedAlready.booleanValue()) {
                    Log.isRecipeAddedAlready = false;
                    Log.logRecipeAlreadyAdded();
                    continue;
                }
                Log.logRecipeSuccess();
            }
            catch (Exception e1) {
                Log.logRecipeFail();
            }
        }
    }

    private static void addRecipe(BlockRecipeData blockData, String device, String material) {
        switch (device) {
            case "craft": {
                RecipeRegistry.addCraftingRecipe(blockData, material);
                break;
            }
            case "furnace": {
                RecipeRegistry.addFurnaceRecipe(blockData, material);
                break;
            }
            case "indsmeltsand": {
                TEIndSmeltRecipeData.addIndSmeltSandRecipe(blockData, material);
                break;
            }
            case "indsmeltrichslag": {
                TEIndSmeltRecipeData.addIndSmeltRichSlagRecipe(blockData, material);
                break;
            }
            case "smeltery": {
                TiCRecipeData.addSmeltRecipe(blockData);
                break;
            }
            case "pulv": {
                TERecipeData.addPulvRecipe(blockData, material);
                break;
            }
            case "redfurn": {
                TERecipeData.addRedFurnRecipe(blockData, material);
                break;
            }
            case "enrich": {
                MekRecipeData.addEnrichRecipe(blockData, material);
                break;
            }
            case "mace": {
                IC2RecipeData.addMaceRecipe(blockData, material);
            }
        }
    }
}

