/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import com.google.common.base.CaseFormat;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.icannt.netherendingores.lib.StringUtil;

public enum BlockRecipeData implements IStringSerializable
{
    END_ALUMINUM_ORE("end_aluminum_ore", "ore_end_modded_1", 0, new String[]{"aluminium"}, "", true, 2, 0),
    END_COPPER_ORE("end_copper_ore", "ore_end_modded_1", 1, new String[0], "", true, 2, 0),
    END_IRIDIUM_ORE("end_iridium_ore", "ore_end_modded_1", 2, new String[0], "", true, 2, 0),
    END_LEAD_ORE("end_lead_ore", "ore_end_modded_1", 3, new String[0], "", true, 2, 0),
    END_MITHRIL_ORE("end_mithril_ore", "ore_end_modded_1", 4, new String[0], "", true, 2, 0),
    END_NICKEL_ORE("end_nickel_ore", "ore_end_modded_1", 5, new String[0], "", true, 2, 0),
    END_PLATINUM_ORE("end_platinum_ore", "ore_end_modded_1", 6, new String[0], "", true, 2, 0),
    END_SILVER_ORE("end_silver_ore", "ore_end_modded_1", 7, new String[0], "", true, 2, 0),
    END_TIN_ORE("end_tin_ore", "ore_end_modded_1", 8, new String[0], "", true, 2, 0),
    END_CERTUS_QUARTZ_ORE("end_certus_quartz_ore", "ore_end_modded_1", 9, new String[0], "dustCertusQuartz", false, 2, 0),
    END_CHARGED_CERTUS_QUARTZ_ORE("end_charged_certus_quartz_ore", "ore_end_modded_1", 10, new String[0], "dustCertusQuartz", false, 2, 0),
    END_OSMIUM_ORE("end_osmium_ore", "ore_end_modded_1", 11, new String[0], "", true, 2, 0),
    END_URANIUM_ORE("end_uranium_ore", "ore_end_modded_1", 12, new String[0], "", false, 2, 0),
    END_YELLORITE_ORE("end_yellorite_ore", "ore_end_modded_1", 13, new String[]{"yellorium"}, "", true, 2, 0),
    END_DILITHIUM_ORE("end_dilithium_ore", "ore_end_modded_1", 14, new String[0], "gem", false, 2, 0),
    END_TRITANIUM_ORE("end_tritanium_ore", "ore_end_modded_1", 15, new String[0], "", true, 2, 0),
    END_ZINC_ORE("end_zinc_ore", "ore_end_modded_2", 0, new String[0], "", true, 2, 0),
    END_COAL_ORE("end_coal_ore", "ore_end_vanilla", 0, new String[0], "coal", true, 2, 0),
    END_DIAMOND_ORE("end_diamond_ore", "ore_end_vanilla", 1, new String[0], "gem", true, 2, 0),
    END_EMERALD_ORE("end_emerald_ore", "ore_end_vanilla", 2, new String[0], "gem", true, 2, 0),
    END_GOLD_ORE("end_gold_ore", "ore_end_vanilla", 3, new String[0], "", true, 2, 0),
    END_IRON_ORE("end_iron_ore", "ore_end_vanilla", 4, new String[0], "", true, 2, 0),
    END_LAPIS_ORE("end_lapis_ore", "ore_end_vanilla", 5, new String[0], "gem", true, 2, 0),
    END_REDSTONE_ORE("end_redstone_ore", "ore_end_vanilla", 6, new String[0], "dust", true, 2, 0),
    NETHER_ALUMINUM_ORE("nether_aluminum_ore", "ore_nether_modded_1", 0, new String[]{"aluminium"}, "", true, 2, 0),
    NETHER_COPPER_ORE("nether_copper_ore", "ore_nether_modded_1", 1, new String[0], "", true, 2, 0),
    NETHER_IRIDIUM_ORE("nether_iridium_ore", "ore_nether_modded_1", 2, new String[0], "", true, 2, 0),
    NETHER_LEAD_ORE("nether_lead_ore", "ore_nether_modded_1", 3, new String[0], "", true, 2, 0),
    NETHER_MITHRIL_ORE("nether_mithril_ore", "ore_nether_modded_1", 4, new String[0], "", true, 2, 0),
    NETHER_NICKEL_ORE("nether_nickel_ore", "ore_nether_modded_1", 5, new String[0], "", true, 2, 0),
    NETHER_PLATINUM_ORE("nether_platinum_ore", "ore_nether_modded_1", 6, new String[0], "", true, 2, 0),
    NETHER_SILVER_ORE("nether_silver_ore", "ore_nether_modded_1", 7, new String[0], "", true, 2, 0),
    NETHER_TIN_ORE("nether_tin_ore", "ore_nether_modded_1", 8, new String[0], "", true, 2, 0),
    NETHER_CERTUS_QUARTZ_ORE("nether_certus_quartz_ore", "ore_nether_modded_1", 9, new String[0], "dustCertusQuartz", false, 2, 0),
    NETHER_CHARGED_CERTUS_QUARTZ_ORE("nether_charged_certus_quartz_ore", "ore_nether_modded_1", 10, new String[0], "dustCertusQuartz", false, 2, 0),
    NETHER_OSMIUM_ORE("nether_osmium_ore", "ore_nether_modded_1", 11, new String[0], "", true, 2, 0),
    NETHER_URANIUM_ORE("nether_uranium_ore", "ore_nether_modded_1", 12, new String[0], "", false, 2, 0),
    NETHER_YELLORITE_ORE("nether_yellorite_ore", "ore_nether_modded_1", 13, new String[]{"yellorium"}, "", true, 2, 0),
    NETHER_DILITHIUM_ORE("nether_dilithium_ore", "ore_nether_modded_1", 14, new String[0], "gem", false, 2, 0),
    NETHER_TRITANIUM_ORE("nether_tritanium_ore", "ore_nether_modded_1", 15, new String[0], "", true, 2, 0),
    NETHER_ZINC_ORE("nether_zinc_ore", "ore_nether_modded_2", 0, new String[0], "", true, 2, 0),
    NETHER_COAL_ORE("nether_coal_ore", "ore_nether_vanilla", 0, new String[0], "coal", true, 2, 0),
    NETHER_DIAMOND_ORE("nether_diamond_ore", "ore_nether_vanilla", 1, new String[0], "gem", true, 2, 0),
    NETHER_EMERALD_ORE("nether_emerald_ore", "ore_nether_vanilla", 2, new String[0], "gem", true, 2, 0),
    NETHER_GOLD_ORE("nether_gold_ore", "ore_nether_vanilla", 3, new String[0], "", true, 2, 0),
    NETHER_IRON_ORE("nether_iron_ore", "ore_nether_vanilla", 4, new String[0], "", true, 2, 0),
    NETHER_LAPIS_ORE("nether_lapis_ore", "ore_nether_vanilla", 5, new String[0], "gem", true, 2, 0),
    NETHER_REDSTONE_ORE("nether_redstone_ore", "ore_nether_vanilla", 6, new String[0], "dust", true, 2, 0),
    OVERWORLD_QUARTZ_ORE("overworld_quartz_ore", "ore_other_1", 0, new String[0], "gem", true, 1, 0),
    END_QUARTZ_ORE("end_quartz_ore", "ore_other_1", 1, new String[0], "gem", true, 1, 0),
    OVERWORLD_ARDITE_ORE("overworld_ardite_ore", "ore_other_1", 2, new String[0], "", true, 1, 0),
    END_ARDITE_ORE("end_ardite_ore", "ore_other_1", 3, new String[0], "", true, 1, 0),
    OVERWORLD_COBALT_ORE("overworld_cobalt_ore", "ore_other_1", 4, new String[0], "", true, 1, 0),
    END_COBALT_ORE("end_cobalt_ore", "ore_other_1", 5, new String[0], "", true, 1, 0);

    private String name;
    private String blockName;
    private int blockMeta;
    private String[] itemAltOreDictSuffix;
    private String itemOreDictPrefix;
    private boolean furnaceItemEnabled;
    private int defaultRecipeMultiplier;
    private int recipeMultiplier;

    private BlockRecipeData(String name, String blockName, int blockMeta, String[] itemAltOreDictSuffix, String itemOreDictPrefix, boolean furnaceItemEnabled, int defaultRecipeMultiplier, int recipeMultiplier) {
        this.name = name;
        this.blockName = blockName;
        this.blockMeta = blockMeta;
        this.itemAltOreDictSuffix = itemAltOreDictSuffix;
        this.itemOreDictPrefix = itemOreDictPrefix;
        this.furnaceItemEnabled = furnaceItemEnabled;
        this.defaultRecipeMultiplier = defaultRecipeMultiplier;
        this.recipeMultiplier = recipeMultiplier;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String[] getItemAltOreDictSuffix() {
        return this.itemAltOreDictSuffix;
    }

    public int getDefaultRecipeMultiplier() {
        return this.defaultRecipeMultiplier;
    }

    public int getRecipeMultiplier() {
        return this.recipeMultiplier;
    }

    public void setRecipeMultiplier(int multiplier) {
        this.recipeMultiplier = multiplier;
    }

    public int getFurnaceAmount() {
        return this.recipeMultiplier;
    }

    public boolean isFurnaceItemEnabled() {
        return this.furnaceItemEnabled;
    }

    public Ingredient[] getConversionIngredient() {
        return new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.getModBlockItemStack()})};
    }

    public ResourceLocation getConversionResourceLocation(String material) {
        return new ResourceLocation("netherendingores:" + this.name + "_to_" + StringUtil.lowerUnder(this.getOreDictOtherModBlockName(material)));
    }

    public String getBlockName() {
        String meta = this.blockMeta > 0 ? ":" + this.blockMeta : "";
        return "netherendingores:" + this.blockName + meta;
    }

    public String getAltMaterialName(String material) {
        return this.name.replace(BlockRecipeData.getRawOreName(this.name), material);
    }

    private String getOreDictOutputName(String type) {
        return this.getOreDictOutputName(this.recipeMultiplier, type, "name");
    }

    public String getOreDictOutputName(String type, String material) {
        return this.getOreDictOutputName(this.recipeMultiplier, type, material);
    }

    private String getOreDictOutputName(int multiplier, String type, String material) {
        material = material == "name" ? this.name : material;
        switch (type) {
            case "smelt": {
                if (multiplier != 1) break;
                return BlockRecipeData.getOreDictSmeltItemName(this.itemOreDictPrefix, material);
            }
            case "crush": {
                if (multiplier != 1 && multiplier != 2) break;
                return BlockRecipeData.getOreDictCrushItemName(this.itemOreDictPrefix, material);
            }
        }
        return this.getOreDictOtherModBlockName(material);
    }

    public String getOreDictRegName() {
        return this.getOreDictPrefixedName(this.recipeMultiplier);
    }

    public String getOreDictOtherModBlockName(String material) {
        return this.getOreDictPrefixedName(1, material);
    }

    public String getOreDictCustomRegName(String material) {
        material = this.name.replace(BlockRecipeData.getRawOreName(this.name), material);
        return this.getOreDictPrefixedName(this.recipeMultiplier, material);
    }

    private String getOreDictPrefixedName(int multiplier) {
        return this.getOreDictPrefixedName(multiplier, this.name);
    }

    private String getOreDictPrefixedName(int multiplier, String material) {
        String prefix = "";
        switch (multiplier) {
            case 0: {
                prefix = "neo";
                break;
            }
            case 1: {
                prefix = "ore";
                material = BlockRecipeData.getRawOreName(material);
                break;
            }
            case 2: {
                prefix = "ore";
                break;
            }
            case 3: {
                prefix = "oreDense";
            }
        }
        return prefix + StringUtil.upperCamel(material.replace("_ore", ""));
    }

    private static String getOreDictSmeltItemName(String prefix, String material) {
        String ore = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, BlockRecipeData.getRawOreName(material));
        switch (prefix) {
            case "": {
                prefix = "ingot";
                break;
            }
            case "dust": 
            case "gem": 
            case "crystal": {
                break;
            }
            default: {
                ore = "";
            }
        }
        return prefix + ore;
    }

    private static String getOreDictCrushItemName(String prefix, String material) {
        String ore = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, BlockRecipeData.getRawOreName(material));
        switch (prefix) {
            case "": 
            case "dust": {
                prefix = "dust";
                break;
            }
            case "gem": 
            case "crystal": {
                break;
            }
            default: {
                ore = "";
            }
        }
        return prefix + ore;
    }

    public String getOreDictCustomItemName(String prefix, String material) {
        return prefix + StringUtil.upperCamel(BlockRecipeData.getRawOreName(material));
    }

    public String getRawOreName() {
        return BlockRecipeData.getRawOreName(this.name);
    }

    private static String getRawOreName(String ore) {
        String[] words;
        for (String word : words = new String[]{"_ore", "overworld_", "nether_", "end_"}) {
            ore = ore.replace(word, "");
        }
        return ore;
    }

    public ItemStack getModBlockItemStack() {
        return new ItemStack(Block.func_149684_b((String)("netherendingores:" + this.blockName)), 1, this.blockMeta);
    }

    public ItemStack getOreDictSmeltItemStack(int amount) {
        return this.getOreDictOutputItemStack("smelt", amount);
    }

    public ItemStack getOreDictCustomItemStack(String prefix, String material, int amount) {
        String oredictName = this.getOreDictCustomItemName(prefix, material);
        return this.getOreDictItemStack(oredictName, amount);
    }

    private ItemStack getOreDictOutputItemStack(String type, int amount) {
        String oredictName = this.getOreDictOutputName(type);
        return this.getOreDictItemStack(oredictName, amount);
    }

    public ItemStack getOreDictOutputItemStack(String type, String material, int amount) {
        String oredictName = this.getOreDictOutputName(type, material);
        return this.getOreDictItemStack(oredictName, amount);
    }

    public ItemStack getOtherModBlockItemStack(String material) {
        for (ItemStack stack : OreDictionary.getOres((String)this.getOreDictOtherModBlockName(material), (boolean)false)) {
            if (stack.func_77973_b().getRegistryName().func_110624_b().equals("netherendingores")) continue;
            return stack;
        }
        return new ItemStack(Items.field_190931_a);
    }

    public ItemStack getOreDictItemStack(String oredictName, int amount) {
        Item itemIn = ((ItemStack)OreDictionary.getOres((String)oredictName, (boolean)false).get(0)).func_77973_b();
        int meta = ((ItemStack)OreDictionary.getOres((String)oredictName, (boolean)false).get(0)).func_77960_j();
        return new ItemStack(itemIn, amount, meta);
    }
}

