/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.lib.config;

import k4unl.minecraft.k4lib.lib.config.Config;
import k4unl.minecraft.k4lib.lib.config.ConfigOption;
import net.minecraftforge.common.config.Configuration;

public class CCConfig
extends Config {
    public static final CCConfig INSTANCE = new CCConfig();
    private String[] blacklistedColors;
    private String[] blacklistedNicks;
    private String[] blacklistedSymbols;

    public void init() {
        this.configOptions.add(new ConfigOption("mode", 1).setComment("Change the mode, [1]Colours can be changed by players, random on login/n[2]Colours can be changed by players, saved between logins/n[3]Only ops can change colours/n[4]Players, Ops have set colours/n[5]Groups determine colours"));
        this.configOptions.add(new ConfigOption("playerColor", "cyan"));
        this.configOptions.add(new ConfigOption("opColor", "darkgreen"));
        this.configOptions.add(new ConfigOption("minimumNickLength", 4));
        this.configOptions.add(new ConfigOption("maximumNickLength", 12));
        this.configOptions.add(new ConfigOption("announceNickChanges", true));
        this.configOptions.add(new ConfigOption("nickChangeOPOnly", false));
        this.configOptions.add(new ConfigOption("leadingSymbolOnNick", '~'));
        this.configOptions.add(new ConfigOption("changeDisplayName", true).setComment("Disable this if you want to use a mod that has bad coding and depends on displayName"));
    }

    public void loadConfigOptions(Configuration c) {
        super.loadConfigOptions(c);
        this.blacklistedColors = c.get("general", "blacklistColors", new String[]{"darkblue", "black"}).getStringList();
        this.blacklistedNicks = c.get("general", "blacklistNicks", new String[]{"K4Unl", "Direwolf20", "Quetzi", "Zness"}).getStringList();
    }

    public boolean isColorBlackListed(String color) {
        for (String blackListed : this.blacklistedColors) {
            if (!blackListed.equals(color)) continue;
            return true;
        }
        return false;
    }

    public boolean isNickBlackListed(String nick) {
        for (String blackListed : this.blacklistedNicks) {
            if (!blackListed.equalsIgnoreCase(nick)) continue;
            return true;
        }
        return false;
    }
}

