/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.lib;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import k4unl.minecraft.colorchat.lib.Group;
import k4unl.minecraft.colorchat.lib.User;

public class Users {
    private static List<User> userList;

    public static void init() {
        userList = new ArrayList<User>();
    }

    public static User getUserByName(String username) {
        for (User u : userList) {
            if (!u.getUserName().equals(username)) continue;
            return u;
        }
        User nUser = new User(username);
        userList.add(nUser);
        return nUser;
    }

    public static User getUserByNick(String nick) {
        for (User u : userList) {
            if (!u.getNick().equals(nick)) continue;
            return u;
        }
        return null;
    }

    public static List<User> getUsersByGroup(Group g) {
        ArrayList<User> userList = new ArrayList<User>();
        for (User u : userList) {
            if (!u.getGroup().equals(g)) continue;
            userList.add(u);
        }
        return userList;
    }

    public static void removeGroupFromUsers(Group g) {
        for (User u : userList) {
            if (!u.getGroup().equals(g)) continue;
            u.setGroup(null);
        }
    }

    public static void readFromFile(File dir) {
        userList.clear();
        if (dir != null) {
            Gson gson = new Gson();
            String p = dir.getAbsolutePath();
            File f = new File(p = p + "/colors.users.json");
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileInputStream ipStream = new FileInputStream(f);
                InputStreamReader reader = new InputStreamReader(ipStream);
                BufferedReader bReader = new BufferedReader(reader);
                String json = bReader.readLine();
                reader.close();
                ipStream.close();
                bReader.close();
                Type myTypeMap = new TypeToken<List<User>>(){}.getType();
                userList = (List)gson.fromJson(json, myTypeMap);
                if (userList == null) {
                    userList = new ArrayList<User>();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveToFile(File dir) {
        if (dir != null) {
            Gson gson = new Gson();
            String json = gson.toJson(userList);
            String p = dir.getAbsolutePath();
            File f = new File(p = p + "/colors.users.json");
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                PrintWriter opStream = new PrintWriter(f);
                opStream.write(json);
                opStream.flush();
                opStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

