/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.lib;

import com.mojang.authlib.GameProfile;
import k4unl.minecraft.colorchat.lib.Colours;
import k4unl.minecraft.colorchat.lib.Group;
import k4unl.minecraft.colorchat.lib.Groups;
import k4unl.minecraft.colorchat.lib.config.CCConfig;
import k4unl.minecraft.k4lib.lib.Functions;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class User {
    private TextFormatting userColor;
    private String nick;
    private String realUserName;
    private boolean hasNick;
    private String group;

    public User(String _username, TextFormatting _userColor, String _nick) {
        this.realUserName = _username;
        this.userColor = _userColor;
        this.nick = _nick;
    }

    public User(String _username) {
        this.realUserName = _username;
        this.userColor = Colours.getRandomColour();
    }

    public String getUserName() {
        return this.realUserName;
    }

    public String getNick() {
        if (this.hasNick) {
            return this.nick;
        }
        return this.realUserName;
    }

    public TextFormatting getColor() {
        return this.userColor;
    }

    public void setNick(String newNick) {
        this.nick = newNick;
        this.hasNick = true;
    }

    public void resetNick() {
        this.hasNick = false;
    }

    public void setUserColor(TextFormatting newColor) {
        this.userColor = newColor;
    }

    public boolean hasNick() {
        return this.hasNick;
    }

    public Group getGroup() {
        return Groups.getGroupByName(this.group);
    }

    public void setGroup(Group newGroup) {
        this.group = newGroup.getName();
    }

    public EntityPlayer getPlayerEntity() {
        for (EntityPlayer player : Functions.getServer().func_184103_al().func_181057_v()) {
            if (!player.func_146103_bH().getName().equals(this.getUserName())) continue;
            return player;
        }
        return null;
    }

    public void updateDisplayName() {
        if (CCConfig.INSTANCE.getBool("changeDisplayName")) {
            this.getPlayerEntity().refreshDisplayName();
        }
    }

    public boolean isOpped() {
        if (this.realUserName.equals("Server")) {
            return true;
        }
        return Functions.isPlayerOpped((GameProfile)this.getPlayerEntity().func_146103_bH());
    }
}

