/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.events;

import java.util.List;
import k4unl.minecraft.colorchat.lib.Colours;
import k4unl.minecraft.colorchat.lib.Groups;
import k4unl.minecraft.colorchat.lib.User;
import k4unl.minecraft.colorchat.lib.Users;
import k4unl.minecraft.colorchat.lib.config.CCConfig;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EventHelper {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHelper());
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        if (!CCConfig.INSTANCE.getBool("changeDisplayName")) {
            TextComponentTranslation orig = (TextComponentTranslation)event.getComponent().func_150259_f();
            List siblings = orig.func_150253_a();
            User usr = Users.getUserByName(event.getUsername());
            String userName = "<";
            if (usr.getGroup() != null) {
                userName = userName + usr.getGroup().getColor() + "[" + usr.getGroup().getName() + "]";
            }
            userName = CCConfig.INSTANCE.getInt("mode") == 4 ? userName + (usr.isOpped() ? CCConfig.INSTANCE.getString("opColor") : CCConfig.INSTANCE.getString("playerColor")) : userName + usr.getColor().toString();
            if (usr.hasNick()) {
                userName = userName + CCConfig.INSTANCE.getChar("leadingSymbolOnNick");
                userName = userName + usr.getNick();
            } else {
                userName = userName + usr.getUserName();
            }
            String chatMessage = TextFormatting.RESET + "> " + event.getMessage().replaceAll("%", "%%");
            String textMessage = userName + chatMessage;
            TextComponentTranslation end = new TextComponentTranslation(textMessage, new Object[0]);
            for (Object s : siblings) {
                end.func_150257_a((ITextComponent)s);
            }
            event.setComponent((ITextComponent)end);
        }
    }

    @SubscribeEvent
    public void getDisplayNameEvent(PlayerEvent.NameFormat event) {
        if (CCConfig.INSTANCE.getBool("changeDisplayName")) {
            User usr = Users.getUserByName(event.getEntityPlayer().func_146103_bH().getName());
            String displayName = "";
            if (usr.getGroup() != null) {
                displayName = displayName + usr.getGroup().getColor() + "[" + usr.getGroup().getName() + "]";
            }
            displayName = CCConfig.INSTANCE.getInt("mode") == 4 ? displayName + (usr.isOpped() ? CCConfig.INSTANCE.getString("opColor") : CCConfig.INSTANCE.getString("playerColor")) : displayName + usr.getColor().toString();
            if (usr.hasNick()) {
                displayName = displayName + CCConfig.INSTANCE.getChar("leadingSymbolOnNick");
                displayName = displayName + usr.getNick();
            } else {
                displayName = displayName + usr.getUserName();
            }
            event.setDisplayname(displayName);
        }
    }

    @SubscribeEvent
    public void saveEvent(WorldEvent.Save event) {
        Users.saveToFile(DimensionManager.getCurrentSaveRootDirectory());
        Groups.saveToFile(DimensionManager.getCurrentSaveRootDirectory());
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (CCConfig.INSTANCE.getInt("mode") == 1) {
            User user = Users.getUserByName(event.player.func_70005_c_());
            TextFormatting colour = Colours.getRandomColour();
            user.setUserColor(colour);
        }
    }
}

