/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.commands;

import com.mojang.authlib.GameProfile;
import k4unl.minecraft.colorchat.lib.Log;
import k4unl.minecraft.colorchat.lib.User;
import k4unl.minecraft.colorchat.lib.Users;
import k4unl.minecraft.colorchat.lib.config.CCConfig;
import k4unl.minecraft.k4lib.commands.CommandK4Base;
import k4unl.minecraft.k4lib.lib.Functions;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandNick
extends CommandK4Base {
    public CommandNick() {
        this.aliases.add("nck");
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (CCConfig.INSTANCE.getBool("nickChangeOPOnly")) {
            if (sender instanceof EntityPlayerMP) {
                return Functions.isPlayerOpped((GameProfile)((EntityPlayerMP)sender).func_146103_bH());
            }
            return true;
        }
        return true;
    }

    public String func_71517_b() {
        return "nick";
    }

    public String func_71518_a(ICommandSender sender) {
        if (CCConfig.INSTANCE.getBool("nickChangeOPOnly")) {
            return "/nick <target> <nick>. Leave nick empty to reset";
        }
        return "/nick <nick>. Leave nick empty to reset";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String nickToSet;
        User target;
        if (CCConfig.INSTANCE.getBool("nickChangeOPOnly")) {
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Please specify a target"));
                return;
            }
            target = Users.getUserByName(args[0]);
            nickToSet = args.length == 2 ? args[1] : "";
        } else {
            target = Users.getUserByName(sender.func_70005_c_());
            nickToSet = args.length == 1 ? args[0] : "";
        }
        if (nickToSet.equals("")) {
            if (CCConfig.INSTANCE.getBool("announceNickChanges")) {
                Functions.sendChatMessageServerWide((TextComponentString)new TextComponentString(TextFormatting.GOLD + target.getNick() + "(" + target.getUserName() + ") is now called " + target.getUserName()));
            }
            target.resetNick();
            target.updateDisplayName();
            sender.func_145747_a((ITextComponent)new TextComponentString("Nick is reset!"));
        } else {
            if (CCConfig.INSTANCE.isNickBlackListed(nickToSet = nickToSet.replace("[", "").replace("]", ""))) {
                Log.error(target.getUserName() + " tried to set a banned nick (" + nickToSet + ")");
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "This nick is banned! You have been reported!"));
                return;
            }
            if (nickToSet.length() >= CCConfig.INSTANCE.getInt("minimumNickLength") && nickToSet.length() <= CCConfig.INSTANCE.getInt("maximumNickLength")) {
                if (CCConfig.INSTANCE.getBool("announceNickChanges")) {
                    Functions.sendChatMessageServerWide((TextComponentString)new TextComponentString(TextFormatting.GOLD + "~" + target.getNick() + "(" + target.getUserName() + ") is now called " + nickToSet));
                }
                target.setNick(nickToSet);
                target.updateDisplayName();
                sender.func_145747_a((ITextComponent)new TextComponentString("Nick is set to " + nickToSet));
                if (CCConfig.INSTANCE.getBool("changeDisplayName")) {
                    ((EntityPlayerMP)sender).refreshDisplayName();
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Your nick should be between " + CCConfig.INSTANCE.getInt("minimumNickLength") + " and " + CCConfig.INSTANCE.getInt("maximumNickLength") + " characters long."));
            }
        }
    }
}

