/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.commands;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import silly511.backups.BackupsMod;
import silly511.backups.commands.RestoreCommand;
import silly511.backups.helpers.BackupHelper;

public class RestoreWorldCommandServer
extends CommandBase {
    public String func_71517_b() {
        return "restoreworld";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.backups.restoreworld.usage";
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return RestoreCommand.getListOfBackups(args);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.backups.restoreworld.usage", new Object[0]);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        BackupHelper.Backup backup = RestoreCommand.parseBackup(args[0]);
        File tempDir = new File(server.func_71238_n(), "temp");
        try {
            Class<?> shutdownHooksClass = Class.forName("java.lang.ApplicationShutdownHooks");
            Field hooksField = shutdownHooksClass.getDeclaredField("hooks");
            hooksField.setAccessible(true);
            IdentityHashMap hooks = (IdentityHashMap)hooksField.get(null);
            Class<?> clazz = shutdownHooksClass;
            synchronized (clazz) {
                Thread oldHook = null;
                for (Thread hook : hooks.values()) {
                    if (hook.getClass().getEnclosingClass() != MinecraftServer.class) continue;
                    oldHook = hook;
                    break;
                }
                if (oldHook == null) {
                    throw new IllegalStateException("Unable to find server shutdown hook");
                }
                Thread finalOldHook = oldHook;
                Thread newHook = new Thread(() -> {
                    finalOldHook.run();
                    try {
                        System.out.println("[Backups]: Restoring backup");
                        BackupHelper.restoreBackup(backup.dir, worldDir, tempDir, null);
                        BackupHelper.setLastBackup(backup.dir.getParentFile(), backup.dir);
                        System.out.println("[Backups]: Backup restored, please restart server");
                    }
                    catch (Exception ex) {
                        System.out.println("[Backups]: Error restoring backup");
                        ex.printStackTrace();
                    }
                }, "Server Shutdown Thread (Wrapped by Backup Restore Thread)");
                hooks.remove(oldHook);
                hooks.put(newHook, newHook);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Error trying to wrap shutdown hook", ex);
        }
        BackupsMod.logger.info("Shutting server down to restore backup");
        server.func_71263_m();
    }
}

