/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.commands;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import silly511.backups.commands.BackupCommand;
import silly511.backups.commands.LastBackupCommand;
import silly511.backups.commands.ListBackupsCommand;
import silly511.backups.commands.RestoreCommand;
import silly511.backups.commands.RestoreWorldCommandClient;
import silly511.backups.commands.RestoreWorldCommandServer;

public class BackupsModCommand
extends CommandBase {
    private final List<CommandBase> subCommands;
    private final String[] nameArray;

    public BackupsModCommand() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new RestoreCommand());
        builder.add((Object)new BackupCommand());
        builder.add((Object)new LastBackupCommand());
        builder.add((Object)new ListBackupsCommand());
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            builder.add((Object)new RestoreWorldCommandServer());
        } else {
            builder.add((Object)new RestoreWorldCommandClient());
        }
        this.subCommands = builder.build();
        this.nameArray = new String[this.subCommands.size()];
        for (int i = 0; i < this.subCommands.size(); ++i) {
            this.nameArray[i] = this.subCommands.get(i).func_71517_b();
        }
    }

    public String func_71517_b() {
        return "backupsmod";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("bm");
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.backups.backupsmod.usage";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return BackupsModCommand.func_71530_a((String[])args, (String[])this.nameArray);
        }
        if (args.length > 1) {
            for (CommandBase subCommand : this.subCommands) {
                if (!subCommand.func_71517_b().equals(args[0])) continue;
                if (!subCommand.func_184882_a(server, sender)) {
                    return Collections.emptyList();
                }
                return subCommand.func_184883_a(server, sender, Arrays.copyOfRange(args, 1, args.length), targetPos);
            }
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            for (CommandBase subCommand : this.subCommands) {
                if (!subCommand.func_71517_b().equals(args[0])) continue;
                if (!subCommand.func_184882_a(server, sender)) {
                    throw new CommandException("commands.generic.permission", new Object[0]);
                }
                subCommand.func_184881_a(server, sender, Arrays.copyOfRange(args, 1, args.length));
                return;
            }
        }
        throw new WrongUsageException("commands.backups.backupsmod.usage", new Object[0]);
    }
}

