/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.client.gui.GuiEnderItemStorage;
import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageSPH;
import codechicken.enderstorage.plugin.EnderItemStoragePlugin;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.ServerUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderItemStorage
extends AbstractEnderStorage
implements IInventory {
    private ItemStack[] items;
    private int open;
    private int size = EnderItemStoragePlugin.configSize;

    public EnderItemStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        this.size = tag.func_74771_c("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((ItemStack[])this.items, (NBTTagList)tag.func_150295_c("Items", 10));
        if (this.size != EnderItemStoragePlugin.configSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderItemStoragePlugin.configSize > this.size) {
            Object[] newItems = new ItemStack[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
            ArrayUtils.fillArray((Object[])newItems, (Object)ItemStack.field_190927_a);
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderItemStoragePlugin.configSize;
            this.func_70296_d();
        } else {
            int numStacks = 0;
            for (ItemStack item : this.items) {
                if (item.func_190926_b()) continue;
                ++numStacks;
            }
            if (numStacks <= EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]) {
                Object[] newItems = new ItemStack[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
                ArrayUtils.fillArray((Object[])newItems, (Object)ItemStack.field_190927_a);
                int copyTo = 0;
                for (ItemStack item : this.items) {
                    if (item.func_190926_b()) continue;
                    newItems[copyTo] = item;
                    ++copyTo;
                }
                this.items = newItems;
                this.size = EnderItemStoragePlugin.configSize;
                this.func_70296_d();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public NBTTagCompound saveToTag() {
        if (this.size != EnderItemStoragePlugin.configSize && this.open == 0) {
            this.alignSize();
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Items", (NBTBase)InventoryUtils.writeItemStacksToTag((ItemStack[])this.items));
        compound.func_74774_a("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70301_a(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70304_b(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.removeStackFromSlot((IInventory)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70299_a(int slot, ItemStack stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.func_70296_d();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int func_70302_i_() {
        return EnderItemStoragePlugin.sizes[this.size];
    }

    public boolean func_191420_l() {
        return ArrayUtils.count((Object[])this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((IInventory)this, (int)slot, (int)size);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.setDirty();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void empty() {
        this.items = new ItemStack[this.func_70302_i_()];
        ArrayUtils.fillArray((Object[])this.items, (Object)ItemStack.field_190927_a);
    }

    public void openSMPGui(EntityPlayer player, String name) {
        ServerUtils.openSMPContainer((EntityPlayerMP)((EntityPlayerMP)player), (Container)new ContainerEnderItemStorage((IInventory)player.field_71071_by, this, false), (player1, windowId) -> {
            PacketCustom packet = new PacketCustom((Object)"ES", 2);
            packet.writeByte(windowId.intValue());
            this.freq.writeToPacket((MCDataOutput)packet);
            packet.writeString(name);
            packet.writeByte(this.size);
            packet.sendToPlayer((EntityPlayer)player1);
        });
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openClientGui(int windowID, InventoryPlayer playerInv, String name, int size) {
        this.size = size;
        this.empty();
        ClientUtils.openSMPGui((int)windowID, (GuiScreen)new GuiEnderItemStorage(playerInv, this, name));
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

