/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.IUnlockableItem;
import com.shinoow.abyssalcraft.api.necronomicon.condition.DefaultCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.DimensionCondition;
import com.shinoow.abyssalcraft.api.necronomicon.condition.IUnlockCondition;
import com.shinoow.abyssalcraft.lib.ACLib;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.ItemEntryGroup;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockProperties;
import thelm.jaopca.api.block.IBlockWithProperty;
import thelm.jaopca.api.item.ItemBase;
import thelm.jaopca.api.item.ItemBlockBase;
import thelm.jaopca.api.item.ItemProperties;
import thelm.jaopca.api.utils.Utils;

public class ModuleAbyssalCraft
extends ModuleBase {
    public static final ArrayList<String> BLACKLIST = Lists.newArrayList((Object[])new String[]{"Iron", "Gold", "Carbon", "Potassium", "Abyssalnite", "LiquifiedCoralium", "Dreadium", "Tin", "Copper", "Silicon", "Magnesium", "Aluminium", "Zinc", "Calcium", "Beryllium"});
    public static final ItemProperties CRYSTAL_PROPERTIES = new ItemProperties().setItemClass(ItemUnlockableBase.class);
    public static final BlockProperties CRYSTAL_CLUSTER_PROPERTIES = new BlockProperties().setHardnessFunc(entry -> 0.4f).setResistanceFunc(entry -> 0.8f).setLightOpacityFunc(entry -> 0).setSoundType(SoundType.field_185853_f).setHarvestTool("pickaxe").setHarvestLevel(3).setFull(false).setOpaque(false).setBoundingBox(new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8)).setItemBlockClass(ItemBlockUnlockableBase.class);
    public static final ItemEntry CRYSTAL_FRAGMENT_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crystalFragment", new ModelResourceLocation("jaopca:crystal_fragment#inventory"), BLACKLIST).setProperties(CRYSTAL_PROPERTIES);
    public static final ItemEntry CRYSTAL_SHARD_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crystalShard", new ModelResourceLocation("jaopca:crystal_shard#inventory"), BLACKLIST).setProperties(CRYSTAL_PROPERTIES);
    public static final ItemEntry CRYSTAL_ENTRY = new ItemEntry(EnumEntryType.ITEM, "crystalAbyss", "crystal", new ModelResourceLocation("jaopca:crystal_abyss#inventory"), BLACKLIST).setProperties(CRYSTAL_PROPERTIES);
    public static final ItemEntry CRYSTAL_CLUSTER_ENTRY = new ItemEntry(EnumEntryType.BLOCK, "crystalCluster", new ModelResourceLocation("jaopca:crystal_cluster#normal"), BLACKLIST).setProperties(CRYSTAL_CLUSTER_PROPERTIES).skipWhenGrouped(true);

    @Override
    public String getName() {
        return "abyssalcraft";
    }

    public List<ItemEntryGroup> getItemRequests() {
        return Lists.newArrayList((Object[])new ItemEntryGroup[]{ItemEntryGroup.of(CRYSTAL_FRAGMENT_ENTRY, CRYSTAL_SHARD_ENTRY, CRYSTAL_ENTRY, CRYSTAL_CLUSTER_ENTRY)});
    }

    @Override
    public void preInit() {
        for (Item item : JAOPCAApi.ITEMS_TABLE.row((Object)"crystalFragment").values()) {
            ((IUnlockableItem)item).setUnlockCondition((IUnlockCondition)new DimensionCondition(ACLib.dreadlands_id));
        }
        for (Item item : JAOPCAApi.ITEMS_TABLE.row((Object)"crystalShard").values()) {
            ((IUnlockableItem)item).setUnlockCondition((IUnlockCondition)new DimensionCondition(ACLib.dreadlands_id));
        }
        for (Item item : JAOPCAApi.ITEMS_TABLE.row((Object)"crystalAbyss").values()) {
            ((IUnlockableItem)item).setUnlockCondition((IUnlockCondition)new DimensionCondition(ACLib.dreadlands_id));
        }
        for (Block block : JAOPCAApi.BLOCKS_TABLE.row((Object)"crystalCluster").values()) {
            ((IUnlockableItem)Item.func_150898_a((Block)block)).setUnlockCondition((IUnlockCondition)new DimensionCondition(ACLib.dreadlands_id));
        }
    }

    @Override
    public void init() {
        AbyssalCraftAPI.registerFuelHandler((IFuelHandler)new JAOPCAAbyssFuelHandler(), (AbyssalCraftAPI.FuelType)AbyssalCraftAPI.FuelType.CRYSTALLIZER);
        AbyssalCraftAPI.registerFuelHandler((IFuelHandler)new JAOPCAAbyssFuelHandler(), (AbyssalCraftAPI.FuelType)AbyssalCraftAPI.FuelType.TRANSMUTATOR);
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crystalFragment")) {
            Utils.addShapelessOreRecipe(Utils.getOreStack("crystalFragment", entry, 9), "crystalShard" + entry.getOreName());
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crystalShard")) {
            Utils.addShapelessOreRecipe(Utils.getOreStack("crystalShard", entry, 1), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName(), "crystalFragment" + entry.getOreName());
            Utils.addShapelessOreRecipe(Utils.getOreStack("crystalShard", entry, 9), "crystal" + entry.getOreName());
            ModuleAbyssalCraft.addSingleCrystallization("ingot" + entry.getOreName(), "crystalShard" + entry.getOreName(), 4, 0.1f);
            ModuleAbyssalCraft.addSingleCrystallization("ore" + entry.getOreName(), "crystalShard" + entry.getOreName(), 4, 0.1f);
            if (Utils.doesOreNameExist("nugget" + entry.getOreName())) {
                ModuleAbyssalCraft.addSingleCrystallization("nugget" + entry.getOreName(), "crystalShard" + entry.getOreName(), 1, 0.1f);
                ModuleAbyssalCraft.addTransmutation("crystalShard" + entry.getOreName(), "nugget" + entry.getOreName(), 1, 0.2f);
            }
            if (!Utils.doesOreNameExist("dust" + entry.getOreName())) continue;
            ModuleAbyssalCraft.addSingleCrystallization("dust" + entry.getOreName(), "crystalShard" + entry.getOreName(), 4, 0.1f);
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crystalAbyss")) {
            Utils.addShapelessOreRecipe(Utils.getJAOPCAOrOreStack("crystalAbyss", "crystal", entry, 1), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName(), "crystalShard" + entry.getOreName());
            Utils.addShapelessOreRecipe(Utils.getJAOPCAOrOreStack("crystalAbyss", "crystal", entry, 9), "crystalCluster" + entry.getOreName());
            if (Utils.doesOreNameExist("block" + entry.getOreName())) {
                ModuleAbyssalCraft.addSingleCrystallization("block" + entry.getOreName(), "crystal" + entry.getOreName(), 4, 0.9f);
            }
            ModuleAbyssalCraft.addTransmutation("crystal" + entry.getOreName(), "ingot" + entry.getOreName(), 1, 0.2f);
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crystalCluster")) {
            Utils.addShapelessOreRecipe(Utils.getOreStack("crystalCluster", entry, 9), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName(), "crystal" + entry.getOreName());
        }
    }

    public static void addSingleCrystallization(String input, String output, int amount, float xp) {
        AbyssalCraftAPI.addSingleCrystallization((String)input, (String)output, (int)amount, (float)xp);
    }

    public static void addTransmutation(String input, String output, int amount, float xp) {
        AbyssalCraftAPI.addTransmutation((String)input, (String)output, (int)amount, (float)xp);
    }

    public static class ItemBlockUnlockableBase
    extends ItemBlockBase
    implements IUnlockableItem {
        private IUnlockCondition condition = new DefaultCondition();

        public ItemBlockUnlockableBase(IBlockWithProperty block) {
            super(block);
        }

        public Item setUnlockCondition(IUnlockCondition condition) {
            this.condition = condition;
            return this;
        }

        public IUnlockCondition getUnlockCondition(ItemStack stack) {
            return this.condition;
        }

        @SideOnly(value=Side.CLIENT)
        public FontRenderer getFontRenderer(ItemStack stack) {
            return APIUtils.getFontRenderer((ItemStack)stack);
        }
    }

    public static class ItemUnlockableBase
    extends ItemBase
    implements IUnlockableItem {
        private IUnlockCondition condition = new DefaultCondition();

        public ItemUnlockableBase(ItemEntry itemEntry, IOreEntry oreEntry) {
            super(itemEntry, oreEntry);
        }

        public Item setUnlockCondition(IUnlockCondition condition) {
            this.condition = condition;
            return this;
        }

        public IUnlockCondition getUnlockCondition(ItemStack stack) {
            return this.condition;
        }

        @SideOnly(value=Side.CLIENT)
        public FontRenderer getFontRenderer(ItemStack stack) {
            return APIUtils.getFontRenderer((ItemStack)stack);
        }
    }

    public static class JAOPCAAbyssFuelHandler
    implements IFuelHandler {
        public int getBurnTime(ItemStack fuel) {
            if (fuel.func_77973_b() instanceof ItemBase) {
                ItemBase item = (ItemBase)fuel.func_77973_b();
                String prefix = item.itemEntry.prefix;
                return prefix.equals("crystal") ? 1350 : (prefix.equals("crystalShard") ? 150 : (prefix.equals("crystalFragment") ? 17 : 0));
            }
            if (fuel.func_77973_b() instanceof ItemBlockBase) {
                ItemBlockBase item = (ItemBlockBase)fuel.func_77973_b();
                String prefix = item.itemEntry.prefix;
                return prefix.equals("crystalCluster") ? 12150 : 0;
            }
            return 0;
        }
    }
}

