/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.JAOPCAApi;

public class Utils {
    public static final ConcurrentMap<String, ItemStack> CACHE = CacheBuilder.newBuilder().maximumSize(200L).build().asMap();
    public static final ConcurrentMap<String, FluidStack> CACHE1 = CacheBuilder.newBuilder().maximumSize(200L).build().asMap();
    public static final LinkedList<String> MOD_IDS = Lists.newLinkedList();

    public static ItemStack getOreStack(String name, int amount) {
        if (CACHE.containsKey(name)) {
            ItemStack ret = ((ItemStack)CACHE.get(name)).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        ItemStack ret = ItemStack.field_190927_a;
        if (!Utils.getOres(name).isEmpty()) {
            NonNullList<ItemStack> list = Utils.getOres(name);
            ret = Utils.getPreferredStack(list);
        }
        if (!ret.func_190926_b()) {
            CACHE.put(name, ret.func_77946_l());
            ret.func_190920_e(amount);
        }
        return ret;
    }

    public static ItemStack getOreStack(String prefix, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getOreName())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getOreName())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE.put(prefix + entry.getOreName(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE.put(prefix + entry.getOreName(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStack(prefix + entry.getOreName(), amount);
    }

    public static ItemStack getJAOPCAOrOreStack(String prefix, String fallback, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getOreName())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getOreName())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE.put(prefix + entry.getOreName(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE.put(prefix + entry.getOreName(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStack(fallback, entry, amount);
    }

    public static ItemStack getOreStackExtra(String prefix, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE.put(prefix + entry.getExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE.put(prefix + entry.getExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStack(prefix + entry.getExtra(), amount);
    }

    public static ItemStack getJAOPCAOrOreStackExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE.put(prefix + entry.getExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE.put(prefix + entry.getExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStackExtra(fallback, entry, amount);
    }

    public static ItemStack getOreStackSecondExtra(String prefix, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getSecondExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getSecondExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE.put(prefix + entry.getSecondExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE.put(prefix + entry.getSecondExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStack(prefix + entry.getSecondExtra(), amount);
    }

    public static ItemStack getJAOPCAOrOreStackSecondExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getSecondExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getSecondExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE.put(prefix + entry.getSecondExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE.put(prefix + entry.getSecondExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStackSecondExtra(fallback, entry, amount);
    }

    public static ItemStack getOreStackThirdExtra(String prefix, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getThirdExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getThirdExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE.put(prefix + entry.getThirdExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE.put(prefix + entry.getThirdExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStack(prefix + entry.getThirdExtra(), amount);
    }

    public static ItemStack getJAOPCAOrOreStackThirdExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        if (CACHE.containsKey(prefix + entry.getThirdExtra())) {
            ItemStack ret = ((ItemStack)CACHE.get(prefix + entry.getThirdExtra())).func_77946_l();
            ret.func_190920_e(amount);
            return ret;
        }
        if (JAOPCAApi.BLOCKS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Block b = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE.put(prefix + entry.getThirdExtra(), new ItemStack(b, 1, 0));
            return new ItemStack(b, amount, 0);
        }
        if (JAOPCAApi.ITEMS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Item i = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE.put(prefix + entry.getThirdExtra(), new ItemStack(i, 1, 0));
            return new ItemStack(i, amount, 0);
        }
        return Utils.getOreStackThirdExtra(fallback, entry, amount);
    }

    public static FluidStack getFluidStack(String name, int amount) {
        if (CACHE1.containsKey(name)) {
            FluidStack ret = ((FluidStack)CACHE1.get(name)).copy();
            ret.amount = amount;
            return ret;
        }
        FluidStack ret = FluidRegistry.getFluidStack((String)name, (int)1);
        if (ret != null) {
            CACHE1.put(name, ret.copy());
            ret.amount = amount;
        }
        return ret;
    }

    public static FluidStack getFluidStack(String prefix, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getOreName());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStack(s, amount);
    }

    public static FluidStack getFluidStackExtra(String prefix, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStack(s, amount);
    }

    public static FluidStack getFluidStackSecondExtra(String prefix, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getSecondExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStack(s, amount);
    }

    public static FluidStack getFluidStackThirdExtra(String prefix, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getThirdExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStack(s, amount);
    }

    public static FluidStack getJAOPCAOrFluidStack(String prefix, String fallback, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getOreName());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getOreName())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getOreName());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStack(fallback, entry, amount);
    }

    public static FluidStack getJAOPCAOrFluidStackExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStackExtra(fallback, entry, amount);
    }

    public static FluidStack getJAOPCAOrFluidStackSecondExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getSecondExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getSecondExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getSecondExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStackSecondExtra(fallback, entry, amount);
    }

    public static FluidStack getJAOPCAOrFluidStackThirdExtra(String prefix, String fallback, IOreEntry entry, int amount) {
        String s = (prefix.isEmpty() ? "" : Utils.toLowerCase(prefix) + '_') + Utils.to_under_score(entry.getThirdExtra());
        if (CACHE1.containsKey(s)) {
            FluidStack ret = ((FluidStack)CACHE1.get(s)).copy();
            ret.amount = amount;
            return ret;
        }
        if (JAOPCAApi.FLUIDS_TABLE.contains((Object)prefix, (Object)entry.getThirdExtra())) {
            Fluid f = (Fluid)JAOPCAApi.FLUIDS_TABLE.get((Object)prefix, (Object)entry.getThirdExtra());
            CACHE1.put(s, new FluidStack(f, 1));
            return new FluidStack(f, amount);
        }
        return Utils.getFluidStackThirdExtra(fallback, entry, amount);
    }

    public static int energyI(IOreEntry entry, double energy) {
        return (int)(energy * entry.getEnergyModifier());
    }

    public static float energyF(IOreEntry entry, double energy) {
        return (float)(energy * entry.getEnergyModifier());
    }

    public static int energyReciprocalI(IOreEntry entry, double energy) {
        return (int)(energy / entry.getEnergyModifier());
    }

    public static float energyReciprocalF(IOreEntry entry, double energy) {
        return (float)(energy / entry.getEnergyModifier());
    }

    public static int rarityI(IOreEntry entry, double rarity) {
        return (int)(rarity * entry.getRarity());
    }

    public static float rarityF(IOreEntry entry, double rarity) {
        return (float)(rarity * entry.getRarity());
    }

    public static int rarityReciprocalI(IOreEntry entry, double rarity) {
        return (int)(rarity / entry.getRarity());
    }

    public static float rarityReciprocalF(IOreEntry entry, double rarity) {
        return (float)(rarity / entry.getRarity());
    }

    public static void addSmelting(ItemStack input, ItemStack output, float xp) {
        if (FurnaceRecipes.func_77602_a().func_151395_a(input).func_190926_b()) {
            GameRegistry.addSmelting((ItemStack)input.func_77946_l(), (ItemStack)output.func_77946_l(), (float)xp);
        }
    }

    public static ItemStack resizeStack(ItemStack stack, int size) {
        if (!stack.func_190926_b()) {
            ItemStack ret = stack.func_77946_l();
            ret.func_190920_e(size);
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean doesOreNameExist(String name) {
        return !OreDictionary.getOres((String)name, (boolean)false).isEmpty();
    }

    public static NonNullList<ItemStack> getOres(String name) {
        return OreDictionary.getOres((String)name, (boolean)false);
    }

    public static ItemStack getPreferredStack(Iterable<ItemStack> itemList) {
        ItemStack ret = ItemStack.field_190927_a;
        int index = Integer.MAX_VALUE;
        for (ItemStack stack : itemList) {
            String modId;
            int idex;
            if (stack.func_190926_b() || (idex = MOD_IDS.indexOf(modId = stack.func_77973_b().getRegistryName().func_110624_b())) >= index) continue;
            index = idex;
            ret = stack;
        }
        return ret.func_77946_l();
    }

    public static String to_under_score(String camelCase) {
        if (StringUtils.isEmpty((CharSequence)camelCase)) {
            return "";
        }
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)camelCase);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            ret.append(StringUtils.uncapitalize((String)strings[i]));
            if (i >= strings.length - 1) continue;
            ret.append('_');
        }
        return ret.toString();
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.US);
    }

    public static String toSpaceSeparated(String camelCase) {
        if (StringUtils.isEmpty((CharSequence)camelCase)) {
            return "";
        }
        String[] strings = StringUtils.splitByCharacterTypeCamelCase((String)camelCase);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            ret.append(StringUtils.capitalize((String)strings[i]));
            if (i >= strings.length - 1 || strings[i].equals("_") || strings[i + 1].equals("_")) continue;
            ret.append(' ');
        }
        return ret.toString();
    }

    public static ItemStack parseItemStack(String input) {
        if (input.startsWith("ore:")) {
            return ItemStack.field_190927_a;
        }
        try {
            int meta = 0;
            int amount = 1;
            String[] split0 = input.split("@");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split0[0]));
            if (split0.length == 2) {
                String[] split1 = split0[1].split("x");
                meta = Integer.parseInt(split1[0]);
                if (split1.length == 2) {
                    amount = Integer.parseInt(split1[1]);
                }
            }
            return new ItemStack(item, amount, meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }

    public static IBlockState parseBlockState(String input) {
        if (input.startsWith("ore:")) {
            return Blocks.field_150350_a.func_176223_P();
        }
        try {
            int meta = 0;
            String[] split = input.split("@");
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0]));
            if (split.length == 2) {
                meta = Integer.parseInt(split[1]);
            }
            return block.func_176203_a(meta);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static EnumOreType oreNameToType(String oreName) {
        return JAOPCAApi.ORE_ENTRY_LIST.stream().filter(entry -> entry.getOreName().equals(oreName)).findAny().get().getOreType();
    }

    public static void addShapedOreRecipe(ItemStack output, Object ... input) {
        Utils.addShapedOreRecipe(Utils.getNameForRecipe(output, input), output, input);
    }

    public static void addShapelessOreRecipe(ItemStack output, Object ... input) {
        Utils.addShapelessOreRecipe(Utils.getNameForRecipe(output, input), output, input);
    }

    public static void addShapedOreRecipe(String path, ItemStack output, Object ... input) {
        ModContainer activeContainer = Loader.instance().activeModContainer();
        Utils.addShapedOreRecipe(new ResourceLocation(activeContainer.getModId(), path), output, input);
    }

    public static void addShapelessOreRecipe(String path, ItemStack output, Object ... input) {
        ModContainer activeContainer = Loader.instance().activeModContainer();
        Utils.addShapelessOreRecipe(new ResourceLocation(activeContainer.getModId(), path), output, input);
    }

    public static void addShapedOreRecipe(ResourceLocation location, ItemStack output, Object ... input) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(output.func_77973_b().getRegistryName(), output, input);
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessOreRecipe(ResourceLocation location, ItemStack output, Object ... input) {
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(output.func_77973_b().getRegistryName(), output, input);
        recipe.setRegistryName(location);
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
    }

    public static ResourceLocation getNameForRecipe(ItemStack output, Object ... input) {
        ModContainer activeContainer = Loader.instance().activeModContainer();
        String path = output.func_77973_b().getRegistryName().func_110623_a();
        ResourceLocation recipeLoc = new ResourceLocation(activeContainer.getModId(), path + "_" + Utils.getDeepToStringHashBase36(input));
        return recipeLoc;
    }

    public static String getDeepToStringHashBase36(Object ... input) {
        String str = Arrays.deepToString(input);
        int i = str.hashCode();
        i = Integer.remainderUnsigned(i, -2118184960);
        str = Integer.toUnsignedString(i, 36);
        i = 6 - str.length();
        for (int j = 0; j < i; ++j) {
            str = "0" + str;
        }
        return str;
    }

    public static String smartLocalize(String key, String specialKeyFormat, IOreEntry entry) {
        String ore = entry.getOreName();
        if (I18n.func_94522_b((String)String.format(specialKeyFormat, ore))) {
            return I18n.func_74838_a((String)String.format(specialKeyFormat, ore)).trim();
        }
        String locOre = I18n.func_94522_b((String)("jaopca.entry." + ore)) ? I18n.func_74838_a((String)("jaopca.entry." + ore)) : Utils.toSpaceSeparated(ore);
        return String.format(I18n.func_74838_a((String)key), locOre).trim();
    }

    public static <E extends Enum<E>> EnumSet<E> enumSetOf(E ... elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("Array must contain at least one element");
        }
        return EnumSet.of(elements[0], elements);
    }
}

