/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.model.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.machinemuse.numina.basemod.MuseLogger;
import net.machinemuse.numina.client.model.obj.MuseOBJLoader;
import net.machinemuse.numina.client.model.obj.MuseOBJModel;
import net.machinemuse.numina.math.Colour;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class MuseModelHelper {
    public static TRSRTransformation get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scaleX, float scaleY, float scaleZ) {
        return new TRSRTransformation(new Vector3f(transformX / 16.0f, transformY / 16.0f, transformZ / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(angleX, angleY, angleZ)), new Vector3f(scaleX, scaleY, scaleZ), null);
    }

    public static TRSRTransformation get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scale) {
        return MuseModelHelper.get(transformX, transformY, transformZ, angleX, angleY, angleZ, scale, scale, scale);
    }

    public static IModel getModel(ResourceLocation resource) {
        MuseOBJModel model = null;
        try {
            model = (MuseOBJModel)MuseOBJLoader.INSTANCE.loadModel(resource);
            model = model.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            e.printStackTrace();
            MuseLogger.logError("Model loading failed :( " + resource);
        }
        return model;
    }

    public static IBakedModel loadBakedModel(ResourceLocation resource, IModelState state) {
        IModel model = MuseModelHelper.getModel(resource);
        if (model != null) {
            IBakedModel bakedModel = model.bake(state, DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Override
                public TextureAtlasSprite apply(ResourceLocation resourceLocation) {
                    return Minecraft.func_71410_x().func_147117_R().func_174942_a(resourceLocation);
                }
            });
            return bakedModel;
        }
        return null;
    }

    public static IBakedModel loadBakedModel(ResourceLocation resource) {
        IModel model = MuseModelHelper.getModel(resource);
        if (model != null) {
            IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)new Function<ResourceLocation, TextureAtlasSprite>(){

                @Override
                public TextureAtlasSprite apply(ResourceLocation resourceLocation) {
                    return Minecraft.func_71410_x().func_147117_R().func_174942_a(resourceLocation);
                }
            });
            return bakedModel;
        }
        return null;
    }

    public static IModel getIModel(ResourceLocation location, int attempt) {
        IModel model;
        String domain = location.func_110624_b();
        String resourePath = location.func_110623_a().replaceFirst("^models/models", "models");
        location = new ResourceLocation(domain, resourePath);
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            model = ModelLoaderRegistry.getMissingModel();
            if (attempt < 6) {
                model = MuseModelHelper.getIModel(location, attempt + 1);
                MuseLogger.logError("Model loading failed on attempt #" + attempt + "  :( " + location.toString());
            }
            MuseLogger.logError("Failed to load model. " + e);
            return MuseModelHelper.getOBJModel(location, 0);
        }
        return model;
    }

    public static IBakedModel getBakedModel(ResourceLocation modellocation, IModelState modelState) {
        IModel model = MuseModelHelper.getIModel(modellocation, 0);
        try {
            return model.bake(modelState, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        catch (Exception e) {
            MuseLogger.logError("Failed to bake model. " + e);
            return ModelLoaderRegistry.getMissingModel().bake(ModelLoaderRegistry.getMissingModel().getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
    }

    public static IModel getOBJModel(ResourceLocation location, int attempt) {
        IModel model;
        String domain = location.func_110624_b();
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            model = ModelLoaderRegistry.getMissingModel();
            if (attempt >= 6) {
                return model;
            }
            MuseModelHelper.getOBJModel(location, attempt + 1);
            MuseLogger.logError("Model loading failed on attempt #" + attempt + "  :( " + location.toString());
            MuseLogger.logError("Failed to load model. " + e);
        }
        return model;
    }

    public static IBakedModel getBakedOBJModel(ResourceLocation modellocation, IModelState modelState) {
        IModel model = MuseModelHelper.getOBJModel(modellocation, 0);
        try {
            return model.bake(modelState, DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
        catch (Exception e) {
            MuseLogger.logError("Failed to bake model. " + e);
            return ModelLoaderRegistry.getMissingModel().bake(ModelLoaderRegistry.getMissingModel().getDefaultState(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
        }
    }

    @Nullable
    public static IExtendedBlockState getStateForPart(List<String> shownIn, MuseOBJModel.MuseOBJBakedModel objBakedModelIn, @Nullable TRSRTransformation transformation) {
        ArrayList<String> hidden = new ArrayList<String>(objBakedModelIn.getModel().getMatLib().getGroups().keySet());
        if (transformation == null) {
            transformation = TRSRTransformation.identity();
        }
        return MuseModelHelper.getStateForPart(shownIn, hidden, transformation);
    }

    @Nullable
    public static List<String> getPartNames(IBakedModel bakedModel) {
        if (bakedModel != null && bakedModel instanceof MuseOBJModel.MuseOBJBakedModel) {
            return new ArrayList<String>(((MuseOBJModel.MuseOBJBakedModel)bakedModel).getModel().getMatLib().getGroups().keySet());
        }
        return null;
    }

    public static IExtendedBlockState getStateForPart(List<String> shownIn, final List<String> hiddenIn, final TRSRTransformation transformation) {
        ExtendedBlockState stateContainer = new ExtendedBlockState(null, new IProperty[0], new IUnlistedProperty[]{Properties.AnimationProperty});
        for (String shown : shownIn) {
            hiddenIn.remove(shown);
        }
        try {
            IModelState state = new IModelState(){
                private final Optional<TRSRTransformation> value;
                {
                    this.value = Optional.of(transformation);
                }

                public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
                    UnmodifiableIterator parts;
                    if (part.isPresent() && (parts = Models.getParts((IModelPart)part.get())).hasNext()) {
                        String name = (String)parts.next();
                        if (!parts.hasNext() && hiddenIn.contains(name)) {
                            return this.value;
                        }
                    }
                    return Optional.empty();
                }
            };
            return ((IExtendedBlockState)stateContainer.func_177621_b()).withProperty(Properties.AnimationProperty, (Object)state);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BakedQuad> getColouredQuadsWithGlowAndTransform(List<BakedQuad> quadList, Colour colour, TRSRTransformation transform, boolean glow) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> builder.add((Object)MuseModelHelper.colouredQuadWithGlowAndTransform(colour, quad, !glow, transform)));
        return builder.build();
    }

    public static BakedQuad colouredQuadWithGlowAndTransform(Colour colour, BakedQuad quad, boolean applyDifuse, TRSRTransformation transform) {
        QuadTransformer transformer = new QuadTransformer(colour, transform, quad.getFormat(), applyDifuse);
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    public static List<BakedQuad> getColoredQuadsWithGlow(List<BakedQuad> quadList, Colour color, boolean glow) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> builder.add((Object)MuseModelHelper.colorQuad(color, quad, !glow)));
        return builder.build();
    }

    public static List<BakedQuad> getColoredQuads(List<BakedQuad> quadList, Colour color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : quadList) {
            builder.add((Object)MuseModelHelper.colorQuad(color, quad, quad.shouldApplyDiffuseLighting()));
        }
        return builder.build();
    }

    public static BakedQuad colorQuad(Colour color, BakedQuad quad, boolean applyDifuse) {
        QuadTransformer transformer = new QuadTransformer(color, quad.getFormat(), applyDifuse);
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    private static class QuadTransformer
    extends VertexTransformer {
        Colour colour;
        Boolean applyDiffuse;
        TRSRTransformation transform;

        public QuadTransformer(Colour colour, VertexFormat format, boolean applyDiffuse) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.colour = colour;
            this.applyDiffuse = applyDiffuse;
        }

        public QuadTransformer(Colour colour, TRSRTransformation transform, VertexFormat format, boolean applyDiffuse) {
            super((IVertexConsumer)new UnpackedBakedQuad.Builder(format));
            this.transform = transform;
            this.colour = colour;
            this.applyDiffuse = applyDiffuse;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.EnumUsage usage = this.parent.getVertexFormat().func_177348_c(element).func_177375_c();
            if (this.colour != null && usage == VertexFormatElement.EnumUsage.COLOR && data.length >= 4) {
                data[0] = (float)this.colour.r;
                data[1] = (float)this.colour.g;
                data[2] = (float)this.colour.b;
                data[3] = (float)this.colour.a;
                super.put(element, data);
            } else if (this.transform != null && usage == VertexFormatElement.EnumUsage.POSITION && data.length >= 4) {
                float[] newData = new float[4];
                Vector4f vec = new Vector4f(data);
                this.transform.getMatrix().transform((Tuple4f)vec);
                vec.get(newData);
                this.parent.put(element, newData);
            } else {
                super.put(element, data);
            }
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            super.setApplyDiffuseLighting(this.applyDiffuse != null ? this.applyDiffuse : diffuse);
        }

        public UnpackedBakedQuad build() {
            return ((UnpackedBakedQuad.Builder)this.parent).build();
        }
    }
}

