/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorLogs
extends GeneratorReplacing {
    protected IProperty axisProperty;
    protected int minLength;
    protected int maxLength;

    public GeneratorLogs(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int minLength, int maxLength) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.axisProperty = GeneratorUtils.getAxisProperty(with);
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        IBlockState state;
        if (!this.placeOn.matches(world, pos.func_177977_b())) {
            return false;
        }
        BlockLog.EnumAxis direction = random.nextInt(2) == 0 ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Z;
        IBlockState iBlockState = state = this.axisProperty == null ? this.with : this.with.func_177226_a(this.axisProperty, (Comparable)direction);
        for (int length = this.minLength + random.nextInt(this.maxLength - this.minLength); length > 0 && this.replace.matches(world, pos) && this.placeOn.matches(world, pos.func_177977_b()); --length) {
            world.func_175656_a(pos, state);
            pos = direction == BlockLog.EnumAxis.X ? pos.func_177974_f() : pos.func_177978_c();
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.with = conf.getBlockState("with", this.with);
        this.axisProperty = GeneratorUtils.getAxisProperty(this.with);
        this.minLength = conf.getInt("minLength", this.minLength);
        this.maxLength = conf.getInt("maxLength", this.maxLength);
        this.placeOn = conf.getBlockPosQuery("placeOn", this.placeOn);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorLogs>
    implements IGenerator.IGeneratorBuilder<GeneratorLogs> {
        protected int minLength;
        protected int maxLength;

        public Builder with(BOPWoods a) {
            this.with = BlockBOPLog.paging.getVariantState(a);
            return (Builder)this.self();
        }

        public Builder with(BlockPlanks.EnumType a) {
            this.with = a.func_176839_a() < 4 ? Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)a) : Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)a);
            return (Builder)this.self();
        }

        public Builder minLength(int a) {
            this.minLength = a;
            return (Builder)this.self();
        }

        public Builder maxLength(int a) {
            this.maxLength = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = new BlockQuery.BlockQueryMaterial(Material.field_151577_b, Material.field_151578_c);
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = Blocks.field_150364_r.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.minLength = 3;
            this.maxLength = 5;
        }

        @Override
        public GeneratorLogs create() {
            return new GeneratorLogs(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.minLength, this.maxLength);
        }
    }
}

