/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.config;

import biomesoplenty.common.remote.TrailManager;
import biomesoplenty.common.util.entity.PlayerUtil;
import biomesoplenty.core.BiomesOPlenty;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MiscConfigurationHandler {
    public static Configuration config;
    public static final String GUI_SETTINGS = "GUI Settings";
    public static final String VISUAL_SETTINGS = "Visual Settings";
    public static final String TRAIL_SETTINGS = "Trail Settings";
    public static boolean useBoPWorldTypeDefault;
    public static boolean overrideTitlePanorama;
    public static boolean enableFogColours;
    public static TrailManager.TrailVisibilityMode trailVisbilityMode;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            MiscConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            useBoPWorldTypeDefault = config.getBoolean("Default to BoP World Type", GUI_SETTINGS, false, "Use the Biomes O' Plenty World Type by default when selecting a world.");
            overrideTitlePanorama = config.getBoolean("Enable Biomes O' Plenty Main Menu Panorama", VISUAL_SETTINGS, true, "Override the main menu panorama and use ours instead (It's nicer!)");
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                enableFogColours = config.getBoolean("Enable Fog Colouration", VISUAL_SETTINGS, true, "Enable fog colouring in some biomes.");
                if (TrailManager.trailsMap.containsKey(PlayerUtil.getClientPlayerUUID())) {
                    trailVisbilityMode = TrailManager.TrailVisibilityMode.values()[config.getInt("Modify Trail Visibility", TRAIL_SETTINGS, 0, 0, 1, "0 = All trails visble, 1 = Others can see your trail but you can't")];
                }
            }
        }
        catch (Exception e) {
            BiomesOPlenty.logger.error("Biomes O' Plenty has encountered a problem loading misc.cfg", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("biomesoplenty")) {
            MiscConfigurationHandler.loadConfiguration();
        }
    }
}

