/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import java.util.Random;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenXericShrubland
extends BOPOverworldBiome {
    public IBlockState usualTopBlock;
    public IBlockState alternateTopBlock;

    public BiomeGenXericShrubland() {
        super("xeric_shrubland", new BOPBiome.PropsBuilder("Xeric Shrubland").withGuiColour(14863781).withTemperature(Float.valueOf(1.75f)).withRainfall(Float.valueOf(0.1f)).withRainDisabled());
        this.terrainSettings.avgHeight(64.0).heightVariation(1.0, 5.0);
        this.field_76752_A = Blocks.field_150354_m.func_176223_P();
        this.field_76753_B = Blocks.field_150354_m.func_176223_P();
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SANDY)).func_177226_a((IProperty)BlockBOPDirt.COARSE, (Comparable)Boolean.valueOf(true));
        this.canSpawnInBiome = false;
        this.canGenerateVillages = true;
        this.addWeight(BOPClimates.HOT_DESERT, 3);
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 4, 2, 3));
        GeneratorWeighted treeGenerator = new GeneratorWeighted(1.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("brush_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().placeOn(BlockQueries.litDry)).minHeight(1)).maxHeight(2)).log(BlockPlanks.EnumType.ACACIA)).leaves(BlockPlanks.EnumType.ACACIA)).create());
        treeGenerator.add("brush_bush", 3, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().placeOn(BlockQueries.litDry)).replace(Material.field_151579_a)).withNonDecayingLeaf(BlockPlanks.EnumType.ACACIA)).create());
        this.addGenerator("dunegrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(10.0f)).with(BOPPlants.DUNEGRASS)).placeOn(this.field_76752_A)).generationAttempts(8)).create());
        this.addGenerator("desertgrass", GeneratorStage.GRASS, ((GeneratorGrass.Builder)((GeneratorGrass.Builder)((GeneratorGrass.Builder)new GeneratorGrass.Builder().amountPerChunk(2.0f)).with(BOPPlants.DESERTGRASS)).generationAttempts(8)).create());
        this.addGenerator("desert_sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(4.0f)).with(BOPPlants.DESERTSPROUTS)).generationAttempts(8)).create());
        this.addGenerator("bromeliad", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).with(BOPFlowers.BROMELIAD)).generationAttempts(8)).create());
        this.addGenerator("dead_bushes", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(Blocks.field_150330_I.func_176223_P())).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 7, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 3, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    @Override
    public void configure(IConfigObj conf) {
        super.configure(conf);
        this.usualTopBlock = this.field_76752_A;
        this.alternateTopBlock = conf.getBlockState("alternateTopBlock", this.alternateTopBlock);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        this.field_76752_A = noise + rand.nextDouble() * 1.0 > 1.9 ? this.alternateTopBlock : this.usualTopBlock;
        super.func_180622_a(world, rand, primer, x, z, noise);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }

    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(13880470);
    }

    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(14278054);
    }
}

