/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.statues.statue;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.init.Blocks;
import party.lemons.statues.statue.EntityStatuePlayer;
import party.lemons.statues.statue.ImageData;

public class ImageStatueBufferDownload
implements IImageBuffer {
    EntityStatuePlayer player;
    IBlockState block;
    int blockSide;
    private int[] imageData;
    private int imageWidth;
    private int imageHeight;
    String debugName;

    public ImageStatueBufferDownload(EntityStatuePlayer entityFakePlayer, IBlockState b, int side, String dn) {
        this.player = entityFakePlayer;
        this.block = b;
        this.blockSide = side;
        this.debugName = dn;
    }

    public BufferedImage func_78432_a(BufferedImage par1BufferedImage) {
        if (par1BufferedImage == null) {
            return null;
        }
        this.imageWidth = 64;
        this.imageHeight = 64;
        BufferedImage bufferedimage1 = new BufferedImage(this.imageWidth, 64, 2);
        Graphics graphics = bufferedimage1.getGraphics();
        graphics.drawImage(par1BufferedImage, 0, 0, null);
        graphics.dispose();
        this.imageData = ((DataBufferInt)bufferedimage1.getRaster().getDataBuffer()).getData();
        if (par1BufferedImage.getHeight() == 32) {
            this.copyArea(0, 16, 15, 32, 16, 48);
            this.copyArea(40, 16, 56, 32, 32, 48);
        }
        if (!this.block.func_177230_c().equals(Blocks.field_150357_h)) {
            this.blendArea(0, 0, this.imageWidth, this.imageHeight, this.block, this.blockSide);
        }
        return bufferedimage1;
    }

    public void func_152634_a() {
    }

    private void copyArea(int x1, int y1, int x2, int y2, int tX1, int tY1) {
        int xO = 0;
        int yO = 0;
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                this.imageData[tX1 + xO + (tY1 + yO) * this.imageWidth] = this.imageData[x + y * this.imageWidth];
                ++yO;
            }
            yO = 0;
            ++xO;
        }
    }

    private void blendArea(int x1, int y1, int x2, int y2, IBlockState block, int side) {
        ImageData sprite = ImageData.getBlockTexture(block);
        if (sprite == null) {
            sprite = ImageData.getBlockTexture(Blocks.field_150348_b.func_176223_P());
        }
        if (sprite == null) {
            return;
        }
        int[] stone = sprite.pixels;
        int w = sprite.w;
        int h = sprite.h;
        for (int x = x1; x < x2; ++x) {
            for (int y = y1; y < y2; ++y) {
                int rgba = this.imageData[x + y * this.imageWidth] & 0xFFFFFFFF;
                double a = (double)(rgba >> 24 & 0xFF) / 255.0;
                double L = 0.2125 * (double)(rgba >> 0 & 0xFF) / 255.0 + 0.7154 * (double)(rgba >> 8 & 0xFF) / 255.0 + 0.0721 * (double)(rgba >> 16 & 0xFF) / 255.0;
                if ((L *= 1.3333333333333333) > 1.0) {
                    L = 1.0;
                }
                int srgba = stone[x % w + y % h * w];
                double R = (double)(srgba >> 0 & 0xFF) / 255.0;
                double G = (double)(srgba >> 8 & 0xFF) / 255.0;
                double B = (double)(srgba >> 16 & 0xFF) / 255.0;
                double A = (double)(srgba >> 24 & 0xFF) / 255.0;
                R = R < 0.5 ? 2.0 * R * L : 1.0 - 2.0 * (1.0 - R) * (1.0 - L);
                G = G < 0.5 ? 2.0 * G * L : 1.0 - 2.0 * (1.0 - G) * (1.0 - L);
                B = B < 0.5 ? 2.0 * B * L : 1.0 - 2.0 * (1.0 - B) * (1.0 - L);
                int sr = (int)(R * 255.0);
                int sg = (int)(G * 255.0);
                int sb = (int)(B * 255.0);
                this.imageData[x + y * this.imageWidth] = sr << 0 | sg << 8 | sb << 16 | (int)(a * A * 255.0) << 24;
            }
        }
    }

    private void setAreaTransparent(int par1, int par2, int par3, int par4) {
        if (!this.hasTransparency(par1, par2, par3, par4)) {
            for (int i1 = par1; i1 < par3; ++i1) {
                for (int j1 = par2; j1 < par4; ++j1) {
                    int n = i1 + j1 * this.imageWidth;
                    this.imageData[n] = this.imageData[n] & 0xFFFFFF;
                }
            }
        }
    }

    private void setAreaOpaque(int par1, int par2, int par3, int par4) {
        for (int i1 = par1; i1 < par3; ++i1) {
            for (int j1 = par2; j1 < par4; ++j1) {
                int n = i1 + j1 * this.imageWidth;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }

    private boolean hasTransparency(int par1, int par2, int par3, int par4) {
        for (int i1 = par1; i1 < par3; ++i1) {
            for (int j1 = par2; j1 < par4; ++j1) {
                int k1 = this.imageData[i1 + j1 * this.imageWidth];
                if ((k1 >> 24 & 0xFF) >= 128) continue;
                return true;
            }
        }
        return false;
    }
}

