/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.statues.statue;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class ImageData {
    static HashMap<IBlockState, ImageData> blockTextures = new HashMap();
    int w;
    int h;
    int[] pixels;
    static ImageData invalidData = new ImageData(null, 0, 0);

    ImageData(int[] pp, int ww, int hh) {
        this.pixels = pp;
        this.w = ww;
        this.h = hh;
    }

    static ImageData getBlockTexture(IBlockState block) {
        ImageData res = blockTextures.get(block);
        if (res == invalidData) {
            return null;
        }
        if (res != null) {
            return res;
        }
        try {
            String name = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block).func_94215_i();
            ResourceLocation nameLoc = new ResourceLocation(name);
            ResourceLocation resource = new ResourceLocation(nameLoc.func_110624_b(), "textures/" + nameLoc.func_110623_a() + ".png");
            BufferedImage origImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
            BufferedImage image = new BufferedImage(origImage.getWidth(), origImage.getHeight(), 2);
            Graphics graphics = image.getGraphics();
            graphics.drawImage(origImage, 0, 0, null);
            graphics.dispose();
            res = new ImageData(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), origImage.getWidth(), origImage.getHeight());
            blockTextures.put(block, res);
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            blockTextures.put(block, invalidData);
            return null;
        }
    }
}

