/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.statues.statue;

import party.lemons.statues.gui.GuiElement;
import party.lemons.statues.gui.InputMouseEvent;
import party.lemons.statues.gui.TexturedBox;

public class Gui2dScroller
extends GuiElement {
    public double u;
    public double v;
    int sliderX;
    int sliderY;
    int sliderW;
    int sliderH;
    int sliderDownX = -1;
    int sliderDownY;
    TexturedBox boxSlider;

    public Gui2dScroller(int x, int y, int w, int h, String rulerTexture, int rw, int rh, int ru, int rv, double initU, double initV) {
        super(x, y, w, h);
        this.sliderW = rw;
        this.sliderH = rh;
        this.boxSlider = new TexturedBox(rulerTexture, ru, rv, this.sliderW, this.sliderH, 0, 0, 0, 0);
        this.set(initU, initV);
    }

    public void set(double uu, double vv) {
        this.u = uu;
        this.sliderX = (int)(this.u * (double)(this.w - this.sliderW));
        this.v = vv;
        this.sliderY = (int)(this.v * (double)(this.h - this.sliderH));
        this.onChange();
    }

    @Override
    public void onAdded() {
    }

    @Override
    public void render() {
        this.boxSlider.render(this.gui, this.x + this.sliderX, this.y + this.sliderY, this.sliderW, this.sliderH);
    }

    @Override
    public void mouseDown(InputMouseEvent ev) {
        if (!this.isMouseOverSlider(ev)) {
            this.sliderDownX = -1;
            return;
        }
        this.sliderDownX = ev.x - this.x - this.sliderX;
        this.sliderDownY = ev.y - this.y - this.sliderY;
    }

    @Override
    public void mouseUp(InputMouseEvent ev) {
        this.sliderDownX = -1;
    }

    @Override
    public void mouseMove(InputMouseEvent ev) {
        if (this.sliderDownX == -1) {
            return;
        }
        int oldSliderX = this.sliderX;
        int oldSliderY = this.sliderY;
        this.sliderX = ev.x - this.sliderDownX - this.x;
        if (this.sliderX < 0) {
            this.sliderX = 0;
        }
        if (this.sliderX >= this.w - this.sliderW) {
            this.sliderX = this.w - this.sliderW;
        }
        this.sliderY = ev.y - this.sliderDownY - this.y;
        if (this.sliderY < 0) {
            this.sliderY = 0;
        }
        if (this.sliderY >= this.h - this.sliderH) {
            this.sliderY = this.h - this.sliderH;
        }
        this.u = 1.0 * (double)this.sliderX / (double)(this.w - this.sliderW);
        this.v = 1.0 * (double)this.sliderY / (double)(this.h - this.sliderH);
        if (oldSliderX != this.sliderX || oldSliderY != this.sliderY) {
            this.onChange();
        }
    }

    boolean isMouseOverSlider(InputMouseEvent ev) {
        return ev.x >= this.x + this.sliderX && ev.x < this.x + this.sliderX + this.sliderW && ev.y >= this.y + this.sliderY && ev.y < this.y + this.sliderY + this.sliderH;
    }

    void onChange() {
    }
}

