/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.statues.statue;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.statues.block.BlockStatue;
import party.lemons.statues.block.entity.TileEntityStatue;
import party.lemons.statues.statue.EntityBadIdea;
import party.lemons.statues.statue.ImageStatueBufferDownload;
import party.lemons.statues.statue.StatueInfo;
import party.lemons.statues.statue.StatueTextureDownloaded;
import party.lemons.statues.statue.StatueTextureStatic;

public class EntityStatuePlayer
extends EntityBadIdea {
    static ResourceLocation STEVE = new ResourceLocation("textures/entity/steve.png");
    static ResourceLocation ALEX = new ResourceLocation("textures/entity/alex.png");
    private String name = "";
    private ResourceLocation skin;
    @SideOnly(value=Side.CLIENT)
    private ITextureObject dataSkin;
    public StatueInfo info;

    public EntityStatuePlayer(World world, String name, BlockPos pos) {
        super(world, new GameProfile(UUID.fromString("a9cb469c-f43d-4925-946d-c85a90e58a15"), name));
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.func_70106_y();
    }

    public TileEntityStatue getTE() {
        TileEntity statue;
        BlockPos ch = this.func_180425_c();
        if (ch.equals((Object)BlockPos.field_177992_a)) {
            return null;
        }
        if (!((Boolean)this.field_70170_p.func_180495_p(ch).func_177229_b((IProperty)BlockStatue.MAIN_PART)).booleanValue()) {
            ch = ch.func_177977_b();
        }
        if ((statue = this.field_70170_p.func_175625_s(ch)) != null && statue instanceof TileEntityStatue) {
            return (TileEntityStatue)statue;
        }
        return null;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            return this.func_184614_ca();
        }
        if (slotIn == EntityEquipmentSlot.OFFHAND) {
            return this.func_184592_cb();
        }
        TileEntityStatue statue = this.getTE();
        if (statue != null) {
            return statue.inventory.func_70301_a(slotIn.func_188454_b());
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return null;
    }

    public ItemStack func_184614_ca() {
        TileEntityStatue statue = this.getTE();
        if (statue != null) {
            return statue.inventory.func_70301_a(4);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184592_cb() {
        TileEntityStatue statue = this.getTE();
        if (statue != null) {
            return statue.inventory.func_70301_a(5);
        }
        return ItemStack.field_190927_a;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return null;
    }

    public EntityStatuePlayer(World world) {
        this(world, "Steve", new BlockPos(0, 0, 0));
    }

    public boolean func_70003_b(int permLevel, String commandName) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void applySkin(String name, IBlockState state, byte facing) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        if (state == null) {
            state = Blocks.field_150348_b.func_176223_P();
        }
        ResourceLocation steveSkin = new ResourceLocation("textures/entity/steve.png|B" + state + "," + facing);
        AbstractTexture steveDataSkin = this.getDataForSteve(steveSkin, new ResourceLocation("textures/entity/steve.png"), state, facing);
        if (!name.isEmpty()) {
            this.skin = new ResourceLocation("skins/" + StringUtils.func_76338_a((String)name) + state + "," + facing);
            this.dataSkin = this.getTextureForSkin(this.skin, steveDataSkin, name, state, facing);
        } else {
            this.skin = steveSkin;
            this.dataSkin = steveDataSkin;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ITextureObject getTextureForSkin(ResourceLocation skin, AbstractTexture fallbackSkin, String name, IBlockState state, byte facing) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        AbstractTexture tex = (AbstractTexture)texturemanager.func_110581_b(skin);
        if (tex == null) {
            GameProfile profile = TileEntitySkull.field_184298_j.func_152655_a(name);
            tex = new StatueTextureDownloaded(profile.getId(), skin, "https://crafatar.com/skins/" + profile.getId() + ".png", fallbackSkin, new ImageStatueBufferDownload(this, state, facing, name + "." + state));
            texturemanager.func_110579_a(skin, (ITextureObject)tex);
        }
        return tex;
    }

    @SideOnly(value=Side.CLIENT)
    public AbstractTexture getDataForSteve(ResourceLocation skin, ResourceLocation base, IBlockState state, byte facing) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        AbstractTexture tex = (AbstractTexture)texturemanager.func_110581_b(skin);
        if (tex == null) {
            tex = new StatueTextureStatic(base, new ImageStatueBufferDownload(this, state, facing, "steve." + state));
            texturemanager.func_110579_a(skin, (ITextureObject)tex);
        }
        return tex;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextureObject getTextureSkin() {
        return this.dataSkin;
    }

    public ResourceLocation getLocationSkin() {
        return this.skin;
    }
}

