/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.inventory.container.SlotHandleClicks;
import codechicken.lib.packet.PacketCustom;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public abstract class ContainerExtended
extends Container
implements IContainerListener {
    public LinkedList<EntityPlayerMP> playerCrafters = new LinkedList();

    public ContainerExtended() {
        this.field_75149_d.add(this);
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        if (listener instanceof EntityPlayerMP) {
            this.playerCrafters.add((EntityPlayerMP)listener);
            this.sendContainerAndContentsToPlayer(this, (NonNullList<ItemStack>)this.func_75138_a(), Collections.singletonList((EntityPlayerMP)listener));
            this.func_75142_b();
        } else {
            super.func_75132_a(listener);
        }
    }

    public void func_82847_b(@Nonnull IContainerListener listener) {
        if (listener instanceof EntityPlayerMP) {
            this.playerCrafters.remove(listener);
        } else {
            super.func_82847_b(listener);
        }
    }

    public void func_71110_a(@Nonnull Container container, @Nonnull NonNullList<ItemStack> list) {
        this.sendContainerAndContentsToPlayer(container, list, this.playerCrafters);
    }

    public void func_175173_a(@Nonnull Container container, @Nonnull IInventory inventory) {
    }

    public void sendContainerAndContentsToPlayer(Container container, NonNullList<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        ItemStack stack;
        LinkedList<ItemStack> largeStacks = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stack = (ItemStack)list.get(i);
            if (!stack.func_190926_b() && stack.func_190916_E() > 127) {
                list.set(i, (Object)ItemStack.field_190927_a);
                largeStacks.add(stack);
                continue;
            }
            largeStacks.add(ItemStack.field_190927_a);
        }
        for (EntityPlayerMP player : playerCrafters) {
            player.func_71110_a(container, list);
        }
        for (int i = 0; i < largeStacks.size(); ++i) {
            stack = (ItemStack)largeStacks.get(i);
            if (stack.func_190926_b()) continue;
            this.sendLargeStack(stack, i, playerCrafters);
        }
    }

    public void sendLargeStack(ItemStack stack, int slot, List<EntityPlayerMP> players) {
    }

    public void func_71112_a(@Nonnull Container container, int i, int j) {
        for (EntityPlayerMP player : this.playerCrafters) {
            player.func_71112_a(container, i, j);
        }
    }

    public void func_71111_a(@Nonnull Container container, int slot, @Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > 127) {
            this.sendLargeStack(stack, slot, this.playerCrafters);
        } else {
            for (EntityPlayerMP player : this.playerCrafters) {
                player.func_71111_a(container, slot, stack);
            }
        }
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int dragType, @Nonnull ClickType clickType, @Nonnull EntityPlayer player) {
        Slot actualSlot;
        if (slot >= 0 && slot < this.field_75151_b.size() && (actualSlot = this.func_75139_a(slot)) instanceof SlotHandleClicks) {
            return ((SlotHandleClicks)actualSlot).slotClick(this, player, dragType, clickType);
        }
        return super.func_184996_a(slot, dragType, clickType, player);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer par1EntityPlayer, int slotIndex) {
        ItemStack transferredStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            transferredStack = stack.func_77946_l();
            if (!this.doMergeStackAreas(slotIndex, stack)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return transferredStack;
    }

    public boolean func_75135_a(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        Slot slot;
        int slotIndex;
        boolean merged = false;
        int n = slotIndex = reverse ? endIndex - 1 : startIndex;
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                ItemStack slotStack = slot.func_75211_c();
                if (!(slotStack.func_190926_b() || slotStack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77952_i() != slotStack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack))) {
                    int maxStackSize;
                    int totalStackSize = slotStack.func_190916_E() + stack.func_190916_E();
                    if (totalStackSize <= (maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a()))) {
                        stack.func_190920_e(0);
                        slotStack.func_190920_e(totalStackSize);
                        slot.func_75218_e();
                        merged = true;
                    } else if (slotStack.func_190916_E() < maxStackSize) {
                        stack.func_190918_g(maxStackSize - slotStack.func_190916_E());
                        slotStack.func_190920_e(maxStackSize);
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = slotIndex = reverse ? endIndex - 1 : startIndex;
            while (stack.func_190916_E() > 0 && (reverse ? slotIndex >= startIndex : slotIndex < endIndex)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                if (!slot.func_75216_d() && slot.func_75214_a(stack)) {
                    int maxStackSize = Math.min(stack.func_77976_d(), slot.func_75219_a());
                    if (stack.func_190916_E() <= maxStackSize) {
                        slot.func_75215_d(stack.func_77946_l());
                        slot.func_75218_e();
                        stack.func_190920_e(0);
                        merged = true;
                    } else {
                        slot.func_75215_d(stack.func_77979_a(maxStackSize));
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                slotIndex += reverse ? -1 : 1;
            }
        }
        return merged;
    }

    public boolean doMergeStackAreas(int slotIndex, ItemStack stack) {
        return false;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        this.bindPlayerInventory(inventoryPlayer, 8, 84);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, slot, x + slot * 18, y + 58));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer var1) {
        return true;
    }

    public void sendContainerPacket(PacketCustom packet) {
        for (EntityPlayerMP player : this.playerCrafters) {
            packet.sendToPlayer((EntityPlayer)player);
        }
    }

    public void handleOutputPacket(PacketCustom packet) {
    }

    public void handleInputPacket(PacketCustom packet) {
    }

    public void handleGuiChange(int ID, int value) {
    }

    public void sendProgressBarUpdate(int barID, int value) {
        for (IContainerListener crafting : this.field_75149_d) {
            crafting.func_71112_a((Container)this, barID, value);
        }
    }
}

